package com.instabug.chat.annotation.utility;

import java.io.Serializable;

/**
 * @author hossam.
 */
public class AspectRatioCalculator implements Serializable {
    private float height = 0.0f;
    private float width = 0.0f;
    private float newHeight = 0.0f;
    private float newWidth = 0.0f;

    public float getFactorHeight() {
        return newHeight == 0.0f || height == 0.0f ? 1 : newHeight / this.height;
    }

    public float getFactorWidth() {
        return newWidth == 0.0f || width == 0.0f ? 1 : newWidth / this.width;
    }

    public float getHeight() {
        return height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public float getWidth() {
        return width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getNewHeight() {
        return newHeight;
    }

    public void setNewHeight(float newHeight) {
        setHeight(this.newHeight);
        this.newHeight = newHeight;
    }

    public float getNewWidth() {
        return newWidth;
    }

    public void setNewWidth(float newWidth) {
        setWidth(this.newWidth);
        this.newWidth = newWidth;
    }
}
