package com.instabug.bug.view.visualusersteps.visitedscreens;

import static com.instabug.library.util.ThemeApplier.applyPrimaryTextStyle;
import static com.instabug.library.util.ThemeApplier.applySecondaryTextStyle;

import android.annotation.SuppressLint;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.instabug.bug.R;
import com.instabug.bug.model.VisitedScreen;
import com.instabug.bug.view.visualusersteps.steppreview.VisualUserStepArgs;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.model.IBGTheme;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.library.util.ThemeApplier;

/**
 * Created by Barakat on 05/05/2019
 */
@SuppressLint("ERADICATE_FIELD_NOT_INITIALIZED")
public class VisualUserStepItemViewHolder extends RecyclerView.ViewHolder implements View.OnClickListener {

    @Nullable
    public final ImageView delete;
    @Nullable
    public final TextView titleTextView;
    @Nullable
    private final ImageView thumbnail;
    @Nullable
    private final TextView subTitle;
    private final VisualUserStepsListContract.View callback;
    private VisitedScreen visitedScreen;
    private String title;

    VisualUserStepItemViewHolder(@NonNull View view, final VisualUserStepsListContract.View callback) {
        super(view);
        titleTextView = view.findViewById(R.id.ib_bug_repro_step_title);
        subTitle = view.findViewById(R.id.ib_bug_repro_step_sub_title);
        thumbnail = view.findViewById(R.id.ib_bug_repro_step_screenshot);
        delete = view.findViewById(R.id.ib_bug_repro_step_delete);
        this.callback = callback;
    }

    void bind(final VisitedScreen visitedScreen, @Nullable IBGTheme theme) {
        this.visitedScreen = visitedScreen;
        title = String.format("%s%s",
                PlaceHolderUtils.getPlaceHolder(
                        itemView.getContext(),
                        InstabugCustomTextPlaceHolder.Key.REPRO_STEPS_LIST_ITEM_NUMBERING_TITLE,
                        R.string.IBGReproStepsListItemName),
                visitedScreen.getScreenIndex());
        String subTitleTxt = visitedScreen.getName() != null ? visitedScreen.getName() : "";

        if (titleTextView != null) {
            this.titleTextView.setText(title);
            applyPrimaryTextStyle(titleTextView, theme);
        }
        if (subTitle != null) {
            subTitle.setText(subTitleTxt);
            applySecondaryTextStyle(subTitle, theme);

        }
        if (thumbnail != null) {
            thumbnail.setImageBitmap(visitedScreen.getScreenShot());
        }
        itemView.setOnClickListener(this);
        if (delete != null) {
            String deleteContentDescription = getDeleteContentDescription(subTitleTxt);
            delete.setContentDescription(deleteContentDescription);
            delete.setOnClickListener(this);

            if(theme != null && theme.getSecondaryTextColor() != ThemeApplier.DEFAULT_COLOR) {
                delete.setColorFilter(theme.getSecondaryTextColor());
            }
        }
    }

    @NonNull
    private String getDeleteContentDescription(String subTitle) {
        return delete == null ? ""
                : delete
                .getContext()
                .getString(R.string.ibg_bug_visited_screen_delete_btn_content_description,
                        title,
                        subTitle);
    }

    @Override
    public void onClick(View v) {
        if (v == itemView) {
            String screenName = visitedScreen.getName() != null ? visitedScreen.getName() : title;
            VisualUserStepArgs args = new VisualUserStepArgs(title,
                    visitedScreen.getScreenshotUri(),
                    screenName
            );

            callback.onStepItemClick(args);
        } else if (v.getId() == R.id.ib_bug_repro_step_delete) {
            callback.onStepItemDelete(getAdapterPosition(), visitedScreen);
        }
    }
}
