package com.instabug.bug.view.reporting.frustratingexperience

import com.instabug.bug.Constants
import com.instabug.bug.extendedbugreport.ExtendedBugReport
import com.instabug.bug.settings.BugSettings
import com.instabug.bug.userConsent.UserConsentsManager
import com.instabug.bug.view.reporting.BaseReportingPresenter
import com.instabug.bug.view.reporting.IBaseReportingView
import com.instabug.library.InstabugCustomTextPlaceHolder
import com.instabug.library.util.PlaceHolderUtils

class FrustratingExperiencePresenter(
    view: IBaseReportingView.View,
    userConsentsManager: UserConsentsManager
) : BaseReportingPresenter(view, userConsentsManager) {
    override fun getTitle(): String {
        var defaultMessage: String? = ""
        if (view != null) {
            val view = this.view.get()
            if (view != null) {
                defaultMessage = view.provideDefaultTitle()
            }
        }
        return PlaceHolderUtils.getPlaceHolder(
            InstabugCustomTextPlaceHolder.Key.FRUSTRATING_EXPERIENCE_TITLE,
            defaultMessage
        )
    }

    override fun getMessageHint(): String {
        var defaultMessage: String? = ""
        if (view != null) {
            val view = this.view.get()
            if (view != null) {
                defaultMessage = view.provideDefaultHintMessage()
            }
        }
        return PlaceHolderUtils.getPlaceHolder(
            InstabugCustomTextPlaceHolder.Key.COMMENT_FIELD_HINT_FOR_FRUSTRATING_EXPERIENCE,
            defaultMessage
        )
    }

    override fun hasExtendedReport(): Boolean =
        (BugSettings.getInstance().getExtraReportFields().isNotEmpty()
                || BugSettings.getInstance().getExtendedBugReportState()
                != ExtendedBugReport.State.DISABLED);


    override fun getReportType(): String = Constants.ReportType.FRUSTRATING_EXPERIENCE
}