package com.instabug.bug.view.disclaimer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.SpannableString;
import android.text.style.UnderlineSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import androidx.annotation.Nullable;

import com.instabug.bug.R;

import java.util.ArrayList;

/**
 * Created by tarek on 8/11/17.
 */

public class DisclaimerListAdapter extends BaseAdapter {

    private Context context;

    private ArrayList<Disclaimer> disclaimers;

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        Disclaimer disclaimer = getItem(position);
        ViewHolder viewHolder;
        if (convertView == null) {
            viewHolder = new ViewHolder();
            LayoutInflater inflater = LayoutInflater.from(context);
            convertView = inflater.inflate(R.layout.instabug_lyt_item_disclaimer, parent, false);
            viewHolder.key = (TextView) convertView.findViewById(R.id.tvKey);
            viewHolder.value = (TextView) convertView.findViewById(R.id.tvValue);
            convertView.setTag(viewHolder);
        } else {
            viewHolder = (ViewHolder) convertView.getTag();
        }

        CharSequence textKey = disclaimer.getKey();

        String textValue;

        if (disclaimer.isLog()) {
            SpannableString spannableString = new SpannableString(textKey);
            spannableString.setSpan(new UnderlineSpan(), 0, spannableString.length(), 0);
            textKey = spannableString;
            textValue = "";
        } else {
            textValue = String.valueOf(disclaimer.getValue());
        }
        if (viewHolder.key != null) {
            viewHolder.key.setText(textKey);
        }
        if (viewHolder.value != null) {
            viewHolder.value.setText(textValue);
        }
        return convertView;
    }

    public DisclaimerListAdapter(Context context, ArrayList<Disclaimer> disclaimers) {
        this.context = context;
        this.disclaimers = disclaimers;
    }

    @Override
    public int getCount() {
        return disclaimers.size();
    }

    @Override
    public Disclaimer getItem(int position) {
        return disclaimers.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @SuppressLint("ERADICATE_FIELD_NOT_INITIALIZED")
    private static class ViewHolder {
        @Nullable
        TextView key;
        @Nullable
        TextView value;
    }

}