package com.instabug.bug.settings;

import android.annotation.SuppressLint;
import android.text.Spanned;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.bug.Constants;
import com.instabug.bug.extendedbugreport.ExtendedBugReport;
import com.instabug.bug.model.ExtraReportField;
import com.instabug.bug.model.ReportCategory;
import com.instabug.bug.onboardingbugreporting.State;
import com.instabug.library.Feature;
import com.instabug.library.OnSdkDismissCallback;
import com.instabug.library.internal.video.customencoding.VideoEncoderConfig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by mohamedzakaria on 6/6/17.
 */

public class PerSessionSettings {

    @Nullable
    private static PerSessionSettings perSessionSettings;
    private AttachmentsTypesParams attachmentsTypesParams;
    @Nullable
    private List<ReportCategory> reportCategories;
    private boolean commentFieldRequired = false;
    @Nullable
    private Runnable preReportRunnable;
    @Nullable
    private Spanned disclaimerText;
    private List<ExtraReportField> extraReportFields;
    @Nullable
    private ExtendedBugReport.State extendedBugReportState;
    @Nullable
    private String extendedBugReportHint1;
    @Nullable
    private String extendedBugReportHint2;
    @Nullable
    private String extendedBugReportHint3;
    private boolean screenshotRequired = false;
    @Nullable
    private OnSdkDismissCallback onSdkDismissCallback;
    private Feature.State bugReportingState = Feature.State.ENABLED;
    private boolean isEmailEnabled = true;
    private boolean isEmailFieldRequired = true;
    private boolean shouldShowSuccessDialog = true;
    private ReportTypesManager reportTypesManager;
    private final Map<String, Integer> reportTypesMinCharLimits;
    @Nullable
    private VideoEncoderConfig videoEncoderConfig;

    int welcomeScreenState = State.LIVE;
    private PerSessionSettings() {
        attachmentsTypesParams = new AttachmentsTypesParams();
        extraReportFields = new ArrayList<>();
        reportTypesManager = ReportTypesManager.getInstance();
        reportTypesMinCharLimits = new HashMap<>();
    }

    private static void init() {
        perSessionSettings = new PerSessionSettings();
    }

    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    public synchronized static PerSessionSettings getInstance() {
        if (perSessionSettings == null) {
            init();
        }
        return perSessionSettings;
    }

    @Nullable
    public List<ReportCategory> getReportCategories() {
        return reportCategories;
    }

    public void setReportCategories(@Nullable List<ReportCategory> reportCategories) {
        this.reportCategories = reportCategories;
    }

    public AttachmentsTypesParams getAttachmentsTypesParams() {
        return attachmentsTypesParams;
    }

    public PerSessionSettings setAttachmentsTypesParams(AttachmentsTypesParams attachmentsTypesParams) {
        this.attachmentsTypesParams = attachmentsTypesParams;
        return this;
    }

    @Nullable
    public OnSdkDismissCallback getOnSdkDismissCallback() {
        return onSdkDismissCallback;
    }

    public void setOnSdkDismissCallback(@Nullable OnSdkDismissCallback onSdkDismissCallback) {
        this.onSdkDismissCallback = onSdkDismissCallback;
    }

    public void setCommentFieldRequired(boolean commentFieldRequired) {
        this.commentFieldRequired = commentFieldRequired;
    }

    public boolean isCommentFieldRequired() {
        return commentFieldRequired;
    }

    @Nullable
    public Runnable getPreReportRunnable() {
        return preReportRunnable;
    }

    /**
     * Set a pre-report runnable. <br/>
     * WARNING: This runs on the application's main UI thread. Please do not include any blocking operations to avoid ANRs.
     *
     * @param preReportRunnable This runnable is run on the UI thread before a bug report/feedback is uploaded to the dashboard
     */
    public void setPreReportRunnable(@Nullable Runnable preReportRunnable) {
        this.preReportRunnable = preReportRunnable;
    }

    @Nullable
    public Spanned getDisclaimerText() {
        return disclaimerText;
    }

    public void setDisclaimerText(@Nullable Spanned disclaimerText) {
        this.disclaimerText = disclaimerText;
    }

    public void addExtraReportField(CharSequence fieldHint, boolean required) {
        extraReportFields.add(new ExtraReportField(fieldHint, required));
    }

    public List<ExtraReportField> getExtraReportFields() {
        return extraReportFields;
    }

    public void clearExtraReportFields() {
        this.extraReportFields.clear();
    }

    void setExtendedBugReportState(@Nullable ExtendedBugReport.State state) {
        this.extendedBugReportState = state;
    }

    ExtendedBugReport.State getExtendedBugReportState() {
        return extendedBugReportState == null ?
                ExtendedBugReport.State.DISABLED : extendedBugReportState;
    }

    void setExtendedBugReportHints(@Nullable String hint1, @Nullable String hint2, @Nullable String hint3) {
        this.extendedBugReportHint1 = hint1;
        this.extendedBugReportHint2 = hint2;
        this.extendedBugReportHint3 = hint3;
    }

    @Nullable
    String getExtendedBugReportHint1() {
        return this.extendedBugReportHint1;
    }

    @Nullable
    String getExtendedBugReportHint2() {
        return this.extendedBugReportHint2;
    }

    @Nullable
    String getExtendedBugReportHint3() {
        return this.extendedBugReportHint3;
    }

    boolean isScreenshotRequired() {
        return screenshotRequired;
    }

    void setScreenshotRequired(boolean screenshotRequired) {
        this.screenshotRequired = screenshotRequired;
    }

    public void setBugReportingState(Feature.State state) {
        bugReportingState = state;
    }

    public boolean isBugReportingStateEnabled() {
        return bugReportingState == Feature.State.ENABLED;
    }

    public void setEmailFieldVisibility(boolean isEmailEnabled) {
        this.isEmailEnabled = isEmailEnabled;
    }

    public boolean isEmailFieldVisible() {
        return isEmailEnabled;
    }

    public boolean isEmailFieldRequired() {
        return isEmailFieldRequired;
    }

    public void setEmailFieldRequired(boolean isEmailRequired) {
        this.isEmailFieldRequired = isEmailRequired;
    }

    public void setSuccessDialogEnabled(boolean shouldShowSuccessDialog) {
        this.shouldShowSuccessDialog = shouldShowSuccessDialog;
    }

    public boolean successDialogEnabled() {
        return shouldShowSuccessDialog;
    }

    public void setReportTypeStatus(@Constants.ReportType String reportType, boolean status) {
        this.reportTypesManager.setReportTypeStatus(reportType, status);
    }


    public boolean getReportTypeStatus(@Constants.ReportType String reportType) {
        return this.reportTypesManager.getReportTypeOptionStatus(reportType);
    }

    public void setReportTypeCommentMinCharLimit(@Constants.ReportType String reportType, int limit) {
        reportTypesMinCharLimits.put(reportType, limit);
    }

    public int getReportTypeMinCommentCharLimit(@Constants.ReportType String reportType) {
        Integer limit = reportTypesMinCharLimits.get(reportType);
        return limit != null ? limit : 0;
    }

    public synchronized static void release() {
        perSessionSettings = null;
    }
    public void setWelcomeScreenState(@State int welcomeScreenState) {
        this.welcomeScreenState = welcomeScreenState;
    }
    public int getWelcomeScreenState() {
       return welcomeScreenState;
   }

    public void setVideoEncoderConfig(@NonNull final VideoEncoderConfig config) {
        this.videoEncoderConfig = config;
    }

    @Nullable
    public VideoEncoderConfig getVideoEncoderConfig() {
        return this.videoEncoderConfig;
    }
}
