package com.instabug.bug.screenshot.viewhierarchy;


import android.graphics.Bitmap;
import android.graphics.Rect;
import android.net.Uri;
import android.view.View;

import androidx.annotation.Nullable;

import org.json.JSONObject;

import java.util.ArrayList;

public class ViewHierarchy {

    @Nullable
    private String id;
    @Nullable
    private String iconIdentifier;
    @Nullable
    private JSONObject frame;
    @Nullable
    private String type;
    @Nullable
    private JSONObject properties;
    @Nullable
    private ViewHierarchy parent;
    private ArrayList<ViewHierarchy> nodes;
    private boolean hasChildren;
    private boolean isRoot;
    @Nullable
    private Bitmap image;
    @Nullable
    private Uri imageUriOnDisk;
    @Nullable
    private Rect originalRect;
    @Nullable
    private Rect visibleRect;
    @Nullable
    private View view;
    private int scale;

    public ViewHierarchy() {
        nodes = new ArrayList<>();
        scale = 1;
    }

    @Nullable
    public String getId() {
        return id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    @Nullable
    public String getIconIdentifier() {
        return iconIdentifier;
    }

    public void setIconIdentifier(@Nullable String iconIdentifier) {
        this.iconIdentifier = iconIdentifier;
    }

    @Nullable
    public String getType() {
        return type;
    }

    public void setType(@Nullable String type) {
        this.type = type;
    }

    @Nullable
    public JSONObject getProperties() {
        return properties;
    }

    public void setProperties(@Nullable JSONObject properties) {
        this.properties = properties;
    }

    @Nullable
    public JSONObject getFrame() {
        return frame;
    }

    public void setFrame(@Nullable JSONObject frame) {
        this.frame = frame;
    }

    @Nullable
    public ViewHierarchy getParent() {
        return parent;
    }

    public void setParent(@Nullable ViewHierarchy parent) {
        this.parent = parent;
    }

    public ArrayList<ViewHierarchy> getNodes() {
        return nodes;
    }

    public void addNode(ViewHierarchy childViewHierarchy) {
        nodes.add(childViewHierarchy);
    }

    public boolean hasChildren() {
        return hasChildren;
    }

    public void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    public boolean isRoot() {
        return isRoot;
    }

    public void setRoot(boolean root) {
        isRoot = root;
    }

    @Nullable
    public Bitmap getImage() {
        return image;
    }

    public void setImage(@Nullable Bitmap image) {
        this.image = image;
    }

    public void removeImage() {
        this.image = null;
    }

    @Nullable
    public Uri getImageUriOnDisk() {
        return imageUriOnDisk;
    }

    public void setImageUriOnDisk(@Nullable Uri imageUriOnDisk) {
        this.imageUriOnDisk = imageUriOnDisk;
    }

    @Nullable
    public Rect getVisibleRect() {
        return visibleRect;
    }

    public void setVisibleRect(@Nullable Rect visibleRect) {
        this.visibleRect = visibleRect;
    }

    @Nullable
    public Rect getOriginalRect() {
        return originalRect;
    }

    public void setOriginalRect(@Nullable Rect originalRect) {
        this.originalRect = originalRect;
    }

    @Nullable
    public View getView() {
        return view;
    }

    public void setView(@Nullable View view) {
        this.view = view;
    }

    public int getScale() {
        return scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }
}
