package com.instabug.bug.onboardingbugreporting;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.RelativeLayout;

import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.core.graphics.ColorUtils;
import androidx.viewpager.widget.ViewPager;

import com.instabug.bug.R;
import com.instabug.library.view.pagerindicator.DotIndicator;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.BaseFragmentActivity;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.ui.custom.InstabugViewPager;
import com.instabug.library.util.AttrResolver;
import com.instabug.library.util.DrawableUtils;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.StatusBarUtils;

import java.io.Serializable;
import java.util.List;


public class OnboardingActivity extends BaseFragmentActivity<OnBoardingPresenter> implements
        OnBoardingActivityContract.View, ViewPager.OnPageChangeListener, View.OnClickListener {
    private static final String EXTRA_STATE = "welcome_state";
    @Nullable
    private InstabugViewPager viewPager;
    @Nullable
    private GenericPagerAdapter adapter;
    @Nullable
    private DotIndicator viewPagerIndicator;
    @Nullable
    private Button doneButton;
    @Nullable
    int state;

    @Override
    protected int getLayout() {
        return R.layout.ib_bg_onboarding_container_activity;
    }

    public static Intent getIntent(Context context, @State int state) {
        Intent onboardingIntent = new Intent(context, OnboardingActivity.class);
        onboardingIntent.putExtra(EXTRA_STATE, state);
        return onboardingIntent;
    }
    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        SettingsManager.getInstance().setOnboardingShowing(true);
        SettingsManager.getInstance().setShouldAutoShowOnboarding(false);
        presenter = new OnBoardingPresenter(this);
        Serializable extraData = null;
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.TIRAMISU) {
            extraData = getIntent().getSerializableExtra(EXTRA_STATE, Serializable.class);
        }else{
            extraData = getIntent().getSerializableExtra(EXTRA_STATE);
        }
        if (extraData != null) {
            state = (int)extraData;
        }

        overridePendingTransition(R.anim.ib_core_anim_fade_in, R.anim.ib_core_anim_fade_out);
        super.onCreate(savedInstanceState);
        StatusBarUtils.setStatusBarColorForPrompt(this);
    }
    @Override
    protected void initViews() {
        viewPager = findViewById(R.id.ib_bg_onboarding_viewpager);
        InstabugViewPager pager = viewPager;
        if (pager != null) {
            DrawableUtils.setColor(pager, AttrResolver.getColor(this,R.attr.instabug_background_color));
            pager.addOnPageChangeListener(this);
            pager.setOffscreenPageLimit(2);
            pager.setAutoHeight(true);
        }

        doneButton = findViewById(R.id.ib_bg_onboarding_done);
        Button button = doneButton;
        if (button != null) {
            button.setOnClickListener(this);
            button.setTextColor(SettingsManager.getInstance().getPrimaryColor());
        }

        viewPagerIndicator = findViewById(R.id.ib_bg_onboarding_viewpager_indicator);
        if (viewPagerIndicator != null) {
            viewPagerIndicator.setSelectedDotColor(SettingsManager.getInstance().getPrimaryColor());
            viewPagerIndicator.setUnselectedDotColor(
                    ColorUtils.setAlphaComponent(SettingsManager.getInstance().getPrimaryColor(), 80));
        }

        if (pager != null && button != null) {
            if (LocaleUtils.isRTL(InstabugCore.getLocale(this))) {
                pager.setRotation(180);
                RelativeLayout.LayoutParams doneButtonLayoutParams = (RelativeLayout.LayoutParams) button.getLayoutParams();
                doneButtonLayoutParams.addRule(RelativeLayout.ALIGN_LEFT, pager.getId());
                button.setLayoutParams(doneButtonLayoutParams);
            } else {
                RelativeLayout.LayoutParams doneButtonLayoutParams = (RelativeLayout.LayoutParams) button.getLayoutParams();
                doneButtonLayoutParams.addRule(RelativeLayout.ALIGN_RIGHT, pager.getId());
                button.setLayoutParams(doneButtonLayoutParams);
            }
        }

        if (presenter != null) {
            presenter.start(state);
        }
    }

    @Override
    public void loadViewPager(List<OnboardingPagerFragment> betaFragments) {
        adapter = new GenericPagerAdapter(getSupportFragmentManager(),betaFragments);
        if (viewPager != null) {
            viewPager.setAdapter(adapter);
        }
        if (viewPagerIndicator != null) {
            viewPagerIndicator.setNumberOfItems(adapter.getCount());
        }
        handleVisibility();
    }

    private void handleVisibility() {
        if (doneButton != null) {
            doneButton.setVisibility(View.GONE);
        }
        if (viewPagerIndicator != null) {
            if (adapter != null && adapter.getCount() > 1) {
                viewPagerIndicator.setVisibility(View.VISIBLE);
            } else {
                viewPagerIndicator.setVisibility(View.GONE);
            }
        }
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

    }

    @Override
    public void onPageSelected(int position) {
        if (viewPagerIndicator != null) {
            viewPagerIndicator.setSelectedItem(position, true);
        }
        if (doneButton != null) {
            if (adapter != null && position == adapter.getCount() - 1 && adapter.getCount() > 1) {
                doneButton.setVisibility(View.VISIBLE);
                doneButton.requestFocus();
            } else {
                doneButton.setVisibility(View.INVISIBLE);
                doneButton.requestFocus(0);
            }
        }
    }

    @Override
    public void onPageScrollStateChanged(int state) {

    }
    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.ib_bg_onboarding_done  || v.getId() == R.id.ib_bg_onboarding_container ) {
            finish();
        }
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
        overridePendingTransition(R.anim.ib_core_anim_fade_in,R.anim.ib_core_anim_fade_out);
    }
    @Override
    public void dismiss() {
        finish();
    }


    @Override
    public void handlePowerByInstabugFooter() {
        View rootView = findViewById(android.R.id.content).getRootView();
        InstabugCore.handlePbiFooter(rootView);
    }

    @Override
    public void finish() {
        super.finish();
        overridePendingTransition(R.anim.ib_core_anim_fade_in, R.anim.ib_core_anim_fade_out);
        SettingsManager.getInstance().setOnboardingShowing(false);
    }

    @Override
    public void enableClickToClose() {
        findViewById(R.id.ib_bg_onboarding_container).setOnClickListener(this);
    }

    @Override
    public String getLocalizedString(@StringRes int resourceId) {
        return LocaleUtils.getLocaleStringResource(InstabugCore.getLocale(OnboardingActivity.this), resourceId,
                OnboardingActivity.this);
    }


}