package com.instabug.chat.synchronization;

import com.instabug.chat.model.Message;

import java.util.List;

import androidx.annotation.NonNull;

/**
 * @author mSobhy
 */
public interface OnNewMessagesReceivedListener {
    /**
     * Called when new messages was received through pulling and after being parsed to a list of
     * messages<br/>
     *
     * @param newMessages List of {@code BaseMessage} representing received messages
     * @return a subset of {@code newMessages} containing messages that wasn't handled by current
     * listener
     */
    List<Message> onNewMessagesReceived(@NonNull List<Message> newMessages);
}
