package com.instabug.chat.model;

import android.annotation.SuppressLint;

import androidx.annotation.Nullable;

import com.instabug.library.internal.storage.cache.Cacheable;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by vezikon on 12/29/15.
 */
public class ReadMessage implements Cacheable {

    // keys used by toJson() & fromJson() methods
    public static final String KEY_CHAT_NUMBER = "chat_number";
    public static final String KEY_READ_AT = "read_at";
    public static final String KEY_MESSAGE_ID = "message_id";

    @Nullable
    private String chatNumber;
    private long readAt;
    @Nullable
    private String messageId;

    @Nullable
    public String getChatNumber() {
        return chatNumber;
    }

    public void setChatNumber(@Nullable String chatNumber) {
        this.chatNumber = chatNumber;
    }

    public long getReadAt() {
        return readAt;
    }

    public void setReadAt(long readAt) {
        this.readAt = readAt;
    }

    @Nullable
    public String getMessageId() {
        return messageId;
    }

    public void setMessageId(@Nullable String messageId) {
        this.messageId = messageId;
    }

    @Override
    public String toJson() throws JSONException {
        JSONObject readMessage = new JSONObject();
        readMessage.put(KEY_READ_AT, getReadAt());
        if (getChatNumber() != null) {
            readMessage.put(KEY_CHAT_NUMBER, getChatNumber());
        }
        if (getMessageId() != null) {
            readMessage.put(KEY_MESSAGE_ID, getMessageId());
        }
        return readMessage.toString();
    }

    @Override
    public void fromJson(String readMessageAsJson) throws JSONException {
        JSONObject readMessageJsonObject = new JSONObject(readMessageAsJson);
        if (readMessageJsonObject.has(KEY_CHAT_NUMBER))
            setChatNumber(readMessageJsonObject.getString(KEY_CHAT_NUMBER));
        if (readMessageJsonObject.has(KEY_MESSAGE_ID))
            setMessageId(readMessageJsonObject.getString(KEY_MESSAGE_ID));
        if (readMessageJsonObject.has(KEY_READ_AT))
            setReadAt(readMessageJsonObject.getLong(KEY_READ_AT));
    }

    @Override
    @SuppressLint("ERADICATE_INCONSISTENT_SUBCLASS_PARAMETER_ANNOTATION")
    public boolean equals(Object readMessage) {
        if (readMessage != null && readMessage instanceof ReadMessage) {
            ReadMessage comparedReadMessage = (ReadMessage) readMessage;
            return String.valueOf(comparedReadMessage.getChatNumber()).equals(
                    String.valueOf(getChatNumber())) && String.valueOf(
                    comparedReadMessage.getMessageId()).equals(String.valueOf(
                    getMessageId())) && comparedReadMessage.getReadAt() == getReadAt();
        } else
            return false;
    }

    @Override
    public int hashCode() {
        if (chatNumber != null) {
            return chatNumber.hashCode();
        }
        return super.hashCode();
    }
}
