package com.instabug.chat.annotation.recognition;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.RectF;

/**
 * Created by Tarek360 on 12/28/16.
 */

public class Utility {

    private static final RectF bounds = new RectF(0, 0, ShapeSpecs.DIMEN, ShapeSpecs.DIMEN);

    public static Path resizePath(Path path) {
        Path resizedPath = new Path(path);
        RectF src = new RectF();
        resizedPath.computeBounds(src, true);

        Matrix resizeMatrix = new Matrix();
        resizeMatrix.setRectToRect(src, bounds, Matrix.ScaleToFit.CENTER);
        resizedPath.transform(resizeMatrix);

        return resizedPath;
    }

    public static Path rotatePath(Path path, int rotation) {

        Path rotatedPath = new Path(path);

        //Rotate path
        Matrix rotationMatrix = new Matrix();
        rotationMatrix.postRotate(rotation, ShapeSpecs.DIMEN / 2, ShapeSpecs.DIMEN / 2);
        rotatedPath.transform(rotationMatrix);

        rotatedPath = resizePath(rotatedPath);

        return rotatedPath;
    }
}
