package com.instabug.chat.annotation;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;

public class ControlButton {

  private static final float CONTROL_BUTTON_RADIUS = 12f;
  private static final float CONTROL_BUTTON_HIT_RADIUS = CONTROL_BUTTON_RADIUS + 30;
  private static final float CONTROL_BUTTON_HIT_RADIUS_POWER_OF_2 =
      CONTROL_BUTTON_HIT_RADIUS * CONTROL_BUTTON_HIT_RADIUS;
  private final Paint paint;
  private PointF centerPoint;
  private int color;

  public ControlButton() {
    centerPoint = new PointF();
    paint = new Paint(Paint.ANTI_ALIAS_FLAG);
  }

  public void setColor(int color) {
    this.color = color;
  }

  public void setCenterPoint(PointF centerPoint) {
    this.centerPoint = centerPoint;
  }

  public void setCenterPoint(float x, float y) {
    this.centerPoint = new PointF(x, y);
  }

  public boolean isTouched(PointF touchedPoint) {

    float dx = centerPoint.x - touchedPoint.x;
    float dy = centerPoint.y - touchedPoint.y;
    float distancePowerOf2 = dx * dx + dy * dy;

    return distancePowerOf2 <= CONTROL_BUTTON_HIT_RADIUS_POWER_OF_2;
  }

  public void draw(Canvas canvas) {
    paint.setColor(color);
    paint.setStyle(Paint.Style.FILL);
    canvas.drawCircle(centerPoint.x, centerPoint.y, CONTROL_BUTTON_RADIUS, paint);
    paint.setColor(Color.WHITE);
    paint.setStyle(Paint.Style.STROKE);
    paint.setStrokeWidth(2);
    canvas.drawCircle(centerPoint.x, centerPoint.y, CONTROL_BUTTON_RADIUS, paint);
  }
}
