package com.instabug.bug.view.reporting.askquestion;

import android.annotation.SuppressLint;

import com.instabug.bug.Constants;
import com.instabug.bug.userConsent.UserConsentRepository;
import com.instabug.bug.userConsent.UserConsentsManager;
import com.instabug.bug.view.reporting.BaseReportingPresenter;
import com.instabug.bug.view.reporting.IBaseReportingView;
import com.instabug.library.util.PlaceHolderUtils;

import static com.instabug.library.InstabugCustomTextPlaceHolder.Key.COMMENT_FIELD_HINT_FOR_QUESTION;
import static com.instabug.library.InstabugCustomTextPlaceHolder.Key.REPORT_QUESTION;

import androidx.annotation.NonNull;

public class AskQuestionPresenter extends BaseReportingPresenter {

    public AskQuestionPresenter(
            IBaseReportingView.View view,
            @NonNull UserConsentsManager userConsentsManager
    ) {
        super(view, userConsentsManager);
    }

    @Override
    @Constants.ReportType
    protected String getReportType() {
        return Constants.ReportType.ASK_QUESTION;
    }


    @Override
    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    public String getMessageHint() {
        String defaultMessage = "";
        if (view != null) {
            IBaseReportingView.View view = this.view.get();
            if (view != null) {
                defaultMessage = view.provideDefaultHintMessage();
            }
        }
        return PlaceHolderUtils.getPlaceHolder(COMMENT_FIELD_HINT_FOR_QUESTION, defaultMessage);
    }

    @Override
    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    public String getTitle() {
        String defaultTitle = "";
        if (view != null) {
            IBaseReportingView.View view = this.view.get();
            if (view != null) {
                defaultTitle = view.provideDefaultTitle();
            }
        }
        return PlaceHolderUtils.getPlaceHolder(REPORT_QUESTION, defaultTitle);
    }


    /**
     * Extended report is disabled by design
     *
     * @return false
     */
    @Override
    public boolean hasExtendedReport() {
        return false;
    }
}
