package com.instabug.bug.utils;

import androidx.annotation.VisibleForTesting;

import com.instabug.library.core.InstabugCore;

/**
 * Created by Barakat on 05/05/2019
 */
public class DisclaimersLinksUtils {

    public static String convertToHTML(String disclaimer, String link, String uri) {
        String html = convertMarkdownLinksToHTMLHyperLinks(disclaimer,
                InstabugCore.getPrimaryColor());
        return replacePlaceholderLinkWithInstabugScheme(html, link, uri);
    }

    public static String convertMarkdownLinksToHTMLHyperLinks(String markdown, int linkTextColor) {
        String regex = "\\[([^\\]]+)\\]\\(([^\\]]+)\\)";
        String replacement = String.format("<font color=\"#%06X\"><a href=\"$2\">$1</a></font>",
                (0xFFFFFF & linkTextColor));
        return markdown.replaceAll(regex, replacement);
    }

    public static String replacePlaceholderLinkWithInstabugScheme(String markdown, String linkPlaceHolder, String uri) {
        return markdown.replace(linkPlaceHolder, uri);
    }

}
