package com.instabug.bug.proactivereporting.configs

import com.instabug.bug.preferences.PrefSpecs
import com.instabug.bug.preferences.bugsPref

interface ProactiveReportingConfigProvider {

    var proactiveReportingBEAvailability: Boolean
    var shouldDropLogs: Boolean
    var modalsGapBEValue: Long
    var detectionGapBEValue: Long
    var proactiveReportingApiAvailability: Boolean
    var modalsGapApiValue: Long
    var detectionGapApiValue: Long

    var isEnabled: Boolean
    var modalsGap: Long
    var detectionGap: Long
    var lastModalTime: Long
}

private const val DETECTION_GAP_API_VALUE_DEFAULT = 0L
private const val MODALS_GAP_API_VALUE_DEFAULT = 0L
private const val PROACTIVE_REPORTING_DEFAULT_API_AVAILABILITY = false

object ProactiveReportingConfigProviderImpl : ProactiveReportingConfigProvider {

    override var proactiveReportingBEAvailability: Boolean by bugsPref(PrefSpecs.ProactiveReportingAvailability)

    override var shouldDropLogs: Boolean by bugsPref(PrefSpecs.ShouldDropLogs)

    override var modalsGapBEValue: Long by bugsPref(PrefSpecs.ModalsGap)

    override var detectionGapBEValue: Long by bugsPref(PrefSpecs.DetectionGap)

    override var lastModalTime: Long by bugsPref(PrefSpecs.LastModalTime)

    override var proactiveReportingApiAvailability: Boolean = PROACTIVE_REPORTING_DEFAULT_API_AVAILABILITY

    override var modalsGapApiValue: Long = MODALS_GAP_API_VALUE_DEFAULT

    override var detectionGapApiValue: Long = DETECTION_GAP_API_VALUE_DEFAULT

    override var isEnabled: Boolean = false
        get() = proactiveReportingBEAvailability && proactiveReportingApiAvailability

    override var detectionGap: Long = detectionGapBEValue
        get() = if (detectionGapApiValue != 0L) detectionGapApiValue else detectionGapBEValue

    override var modalsGap: Long = modalsGapBEValue
        get() = if (modalsGapApiValue != 0L) modalsGapApiValue else modalsGapBEValue

}