package com.instabug.bug.mocks

import android.content.SharedPreferences
import android.content.SharedPreferences.OnSharedPreferenceChangeListener

class MockSharedPreferences : SharedPreferences {
    private val editor: Editor = Editor()
    private val valuesMap = HashMap<String, Any?>()
    override fun getAll(): Map<String, *> {
        return valuesMap
    }

    override fun getString(key: String, defValue: String?): String? {
        return if (valuesMap.containsKey(key)) {
            valuesMap[key] as String?
        } else defValue
    }

    override fun getStringSet(key: String, defValues: Set<String>?): Set<String>? {
        return if (valuesMap.containsKey(key)) {
            valuesMap[key] as Set<String>?
        } else defValues
    }

    override fun getInt(key: String, defValue: Int): Int {
        return if (valuesMap.containsKey(key)) {
            valuesMap[key] as Int
        } else defValue
    }

    override fun getLong(key: String, defValue: Long): Long {
        return if (valuesMap.containsKey(key)) {
            valuesMap[key] as Long
        } else defValue
    }

    override fun getFloat(key: String, defValue: Float): Float {
        return if (valuesMap.containsKey(key)) {
            valuesMap[key] as Float
        } else defValue
    }

    override fun getBoolean(key: String, defValue: Boolean): Boolean {
        return if (valuesMap.containsKey(key)) {
            valuesMap[key] as Boolean
        } else defValue
    }

    override fun contains(key: String): Boolean {
        return valuesMap.containsKey(key)
    }

    override fun edit(): Editor {
        return editor
    }

    override fun registerOnSharedPreferenceChangeListener(listener: OnSharedPreferenceChangeListener) {}
    override fun unregisterOnSharedPreferenceChangeListener(listener: OnSharedPreferenceChangeListener) {}
    inner class Editor : SharedPreferences.Editor {
        private val editorMap = HashMap<String, Any?>()
        override fun putString(key: String, value: String?): SharedPreferences.Editor {
            editorMap[key] = value
            return this
        }

        override fun putStringSet(key: String, values: Set<String>?): SharedPreferences.Editor {
            editorMap[key] = values
            return this
        }

        override fun putInt(key: String, value: Int): SharedPreferences.Editor {
            editorMap[key] = value
            return this
        }

        override fun putLong(key: String, value: Long): SharedPreferences.Editor {
            editorMap[key] = value
            return this
        }

        override fun putFloat(key: String, value: Float): SharedPreferences.Editor {
            editorMap[key] = value
            return this
        }

        override fun putBoolean(key: String, value: Boolean): SharedPreferences.Editor {
            editorMap[key] = value
            return this
        }

        override fun remove(key: String): SharedPreferences.Editor {
            editorMap.remove(key)
            return this
        }

        override fun clear(): SharedPreferences.Editor {
            editorMap.clear()
            return edit()
        }

        override fun commit(): Boolean {
            valuesMap.clear()
            valuesMap.putAll(editorMap)
            return true
        }

        override fun apply() {
            valuesMap.clear()
            valuesMap.putAll(editorMap)
        }
    }
}