package com.instabug.bug.internal.video;

import android.annotation.SuppressLint;
import android.content.Context;
import android.widget.MediaController;

import androidx.annotation.NonNull;


@SuppressLint("ViewConstructor")
public class InstabugMediaController extends MediaController {
    @NonNull
    private final OnVisibilityChangedListener onVisibilityChangedListener;

    public InstabugMediaController(Context context, @NonNull OnVisibilityChangedListener onVisibilityChangedListener) {
        super(context);
        this.onVisibilityChangedListener = onVisibilityChangedListener;
    }

    @Override
    public void show() {
        super.show();
        if (onVisibilityChangedListener != null) {
            onVisibilityChangedListener.isVisible(true);
        }
    }

    @Override
    public void hide() {
        super.hide();
        if (onVisibilityChangedListener != null) {
            onVisibilityChangedListener.isVisible(false);
        }
    }

    interface OnVisibilityChangedListener {
        void isVisible(boolean isVisible);
    }
}