package com.instabug.bug.instabugdisclaimer;

import static com.instabug.bug.BugReportingWrapper.setReportTypes;

import android.text.Spanned;

import com.instabug.bug.BugReporting;
import com.instabug.bug.settings.BugSettings;
import com.instabug.bug.view.disclaimer.DisclaimerHelper;
import com.instabug.chat.Replies;
import com.instabug.library.Feature;


import com.instabug.library.IBGFeature;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.settings.SettingsManager;

/**
 * Created by tarek on 8/15/17.
 */

class InstabugDisclaimer {

    private static final String googleDisclaimer = "Disclaimer: Once submitted, this feedback and [metadata]" +
            "(#metadata-screen) will be sent to and stored on Instabug's servers.<P/><P/>[Learn more]" +
            "(http://grasshopper.codes).";

    static void setup() {
        InstabugCore.setFeatureState(IBGFeature.CONSOLE_LOGS, Feature.State.DISABLED);
        InstabugCore.setFeatureState(IBGFeature.TRACK_USER_STEPS, Feature.State.DISABLED);
        InstabugCore.setFeatureState(IBGFeature.REPRO_STEPS, Feature.State.DISABLED);
        InstabugCore.setFeatureState(IBGFeature.VIEW_HIERARCHY_V2, Feature.State.DISABLED);

        Replies.setState(Feature.State.DISABLED);
        BugReporting.setState(Feature.State.ENABLED);
        setReportTypes(BugReporting.ReportType.BUG, BugReporting.ReportType.FEEDBACK);

        SettingsManager.getInstance().setIsSessionEnabled(false);
        setGoogleDisclaimerText(googleDisclaimer);

    }

    static void setGoogleDisclaimerText(String disclaimer) {
        if (InstabugCore.getFeatureState(IBGFeature.DISCLAIMER) == Feature.State.ENABLED) {
            Spanned spanned = DisclaimerHelper.getSpannedDisclaimer(disclaimer);
            BugSettings.getInstance().setDisclaimerText(spanned);
        }
    }

}
