package com.instabug.chat.annotation;

import androidx.annotation.Nullable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

/**
 * Created by tarek on 11/20/16.
 */

public class MarkUpStack implements Serializable {

    private ArrayList<MarkUpDrawable> markUps;
    private ArrayList<MarkUpDrawable> onTopMarkUps;
    private ArrayList<MarkUpDrawable> onBottomMarkUps;
    private Stack<MarkUpDrawable> markUpsActionsHistory;

    public MarkUpStack() {
        markUps = new ArrayList<>();
        onTopMarkUps = new ArrayList<>();
        onBottomMarkUps = new ArrayList<>();
        markUpsActionsHistory = new Stack<>();
    }

    public void addOnTop(MarkUpDrawable markUpDrawable) {

        onTopMarkUps.add(markUpDrawable);
        update();
        markUpsActionsHistory.add(markUpDrawable);
    }

    public void addOnBottom(MarkUpDrawable markUpDrawable) {

        onBottomMarkUps.add(markUpDrawable);
        update();
        markUpsActionsHistory.add(markUpDrawable);
    }

    private void update() {

        markUps.clear();
        markUps.addAll(onBottomMarkUps);
        markUps.addAll(onTopMarkUps);
    }

    public List<MarkUpDrawable> getAll() {
        return markUps;
    }

    public void remove(MarkUpDrawable markUpDrawable) {
        if (!onTopMarkUps.remove(markUpDrawable)) {
            onBottomMarkUps.remove(markUpDrawable);
        }
        markUps.remove(markUpDrawable);

        //Clear all of references of this markUpDrawable in markUpsActionsHistory
        while (true) {
            int index = markUpsActionsHistory.indexOf(markUpDrawable);
            if (index != -1) {
                markUpsActionsHistory.remove(index);
            } else {
                break;
            }
        }
    }

    public MarkUpDrawable get(int index) {
        return markUps.get(index);
    }

    public int size() {
        return markUps.size();
    }

    public int indexOf(MarkUpDrawable markUpDrawable) {
        return markUps.indexOf(markUpDrawable);
    }

    /*
     *@return the removed MarkUpDrawable or null if no thing is removed
     * note: undo isn't only for removing the MarkUpDrawable but it undo the MarkUpDrawable state too.
     */
    @Nullable
    public MarkUpDrawable undo() {
        if (markUpsActionsHistory.size() > 0) {
            MarkUpDrawable lastDraggedMarkUp = markUpsActionsHistory.pop();

            boolean canBack = lastDraggedMarkUp.back();
            if (!canBack) {
                remove(lastDraggedMarkUp);
                return lastDraggedMarkUp;
            }
        }
        return null;
    }

    public void onStateChangedMarkUpDrawable(@Nullable MarkUpDrawable markUpDrawable) {
        if (markUpDrawable != null)
            markUpsActionsHistory.push(markUpDrawable);
    }
}
