package com.instabug.bug.view.visualusersteps.visitedscreens;

import com.instabug.bug.model.VisitedScreen;

import java.util.List;

import androidx.recyclerview.widget.DiffUtil;

/**
 Created by Barakat on 09/05/2019
 */

/**
 A utility class that can calculate the difference between two lists
 and output a list of update operations that converts the first list into the second one.
 It can be used to calculate updates for a RecyclerView Adapter.
 */

public class VisitedScreensDiffUtils extends DiffUtil.Callback {

    private final List<VisitedScreen> oldList;
    private final List<VisitedScreen> newList;

    public VisitedScreensDiffUtils(List<VisitedScreen> oldList, List<VisitedScreen> newList) {
        this.oldList = oldList;
        this.newList = newList;
    }

    @Override
    public int getOldListSize() {
        return oldList.size();
    }

    @Override
    public int getNewListSize() {
        return newList.size();
    }

    @Override
    public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        return oldList.get(oldItemPosition).getScreenIndex() == newList.get(newItemPosition).getScreenIndex();
    }

    @Override
    public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        return newList.get(newItemPosition).equals(oldList.get(oldItemPosition));
    }
}
