package com.instabug.bug.model;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;

import androidx.annotation.Nullable;

/**
 Created by Barakat on 07/05/2019
 */
public class VisitedScreen {

    private int screenIndex;
    @Nullable
    private String name;
    private String screenshotId;
    private String screenshotUri;
    private Bitmap screenShot;

    public VisitedScreen(int screenIndex,
                         @Nullable String screenName,
                         String screenshotId,
                         String screenshotUri,
                         Bitmap screenshotBitmap) {
        this.screenIndex = screenIndex;
        this.name = screenName;
        this.screenshotId = screenshotId;
        this.screenshotUri = screenshotUri;
        this.screenShot = screenshotBitmap;
    }

    @Nullable
    public String getName() {
        return name;
    }

    public Bitmap getScreenShot() {
        return screenShot;
    }

    public String getScreenshotUri() {
        return screenshotUri;
    }

    public int getScreenIndex() {
        return screenIndex;
    }

    public String getScreenshotId() {
        return screenshotId;
    }

    @Override
    @SuppressLint("ERADICATE_INCONSISTENT_SUBCLASS_PARAMETER_ANNOTATION")
    public boolean equals(Object obj) {
        if (obj instanceof VisitedScreen) {
            VisitedScreen compare = (VisitedScreen) obj;
            return this.getScreenIndex() == compare.getScreenIndex()
                    && this.getScreenshotId().equals(compare.getScreenshotId());
        }
        return false;
    }

    public int hashCode() {
        // Fixing FindBugs Warning
        // any arbitrary constant will prevent the class to be very likely to violate the invariant that equal objects must have equal hashcodes.
        return 88;
    }
}
