package com.instabug.bug.cache.migrationpolicy;

import android.content.ContentValues;

import com.instabug.bug.Constants;
import com.instabug.bug.cache.BugReportsDbHelper;
import com.instabug.bug.di.ServiceLocator;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.storage.cache.dbv2.migration.MigrationInterruptedException;
import com.instabug.library.util.InstabugSDKLogger;

public class InterTableMigrationInterruptionsPolicy implements MigrationInterruptionPolicy {
    private final Exception withException;
    private BugReportsDbHelper<ContentValues> bugReportsPlainDbHelper;

    public InterTableMigrationInterruptionsPolicy(Exception e) {
        withException = e;
        bugReportsPlainDbHelper = ServiceLocator.getBugReportsPlainDbHelper();
    }

    /**
     * Drop the bugs as they are not encrypt-able
     */
    @Override
    public void migrate() {
        bugReportsPlainDbHelper.deleteAll();
        String message = "Failed to migrate bugs to encrypted DB, dropping them.";
        InstabugSDKLogger.e(Constants.LOG_TAG, message, withException);
        IBGDiagnostics.reportNonFatal(
                new MigrationInterruptedException(withException.getMessage()),
                message);
    }
}
