/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.bug.f;
import com.instabug.bug.internal.video.ScreenRecordingService;
import com.instabug.bug.invocation.b;
import com.instabug.bug.utils.c;
import com.instabug.bug.view.actionList.service.a;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventSubscriber;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.core.eventbus.eventpublisher.IBGCompositeDisposable;
import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable;
import com.instabug.library.core.plugin.Plugin;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.internal.video.ScreenRecordingServiceData;
import com.instabug.library.internal.video.ScreenRecordingServiceEventBus;
import com.instabug.library.invocation.InvocationManagerContract;
import com.instabug.library.invocation.util.InstabugFloatingButtonEdge;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tokenmapping.MappedTokenChangedEventBus;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.visualusersteps.ReproConfigurationsProvider;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Locale;

public class BugPlugin
extends Plugin {
    public static final String SCREEN_RECORDING_EVENT_NAME = "SendDataToRecordingService";
    @Nullable
    private IBGCompositeDisposable disposables;
    @Nullable
    @VisibleForTesting
    IBGDisposable mappedTokenChangedDisposable;

    private void initInvocationManager() {
        b.g().d().a(InstabugFloatingButtonEdge.RIGHT);
        b.g().notifyPrimaryColorChanged();
        b.g().b(InstabugCore.getInvocationEvents());
        CoreServiceLocator.setInvocationManagerContract((InvocationManagerContract)b.g());
    }

    private void subscribeOnCoreEvents() {
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null && weakReference.get() != null) {
            this.getOrCreateCompositeDisposables().add(this.subscribeToCoreEvents());
        }
    }

    @NonNull
    private IBGDisposable subscribeToCoreEvents() {
        return IBGCoreEventSubscriber.subscribe(iBGSdkCoreEvent -> {
            WeakReference weakReference = ((Plugin)weakReference).contextWeakReference;
            if (weakReference != null) {
                com.instabug.bug.b.a((Context)weakReference.get(), iBGSdkCoreEvent);
            }
        });
    }

    private void subscribeOnMappedTokenChangedEvent() {
        if (this.mappedTokenChangedDisposable == null) {
            this.mappedTokenChangedDisposable = MappedTokenChangedEventBus.INSTANCE.subscribe(bl -> {
                a.b().d();
                a.b().start();
            });
        }
    }

    private void unsubscribeFromMappedTokenChangedEvents() {
        IBGDisposable iBGDisposable = this.mappedTokenChangedDisposable;
        if (iBGDisposable != null) {
            iBGDisposable.dispose();
            this.mappedTokenChangedDisposable = null;
        }
    }

    private void loadAndApplyCachedReproConfigurations() {
        SettingsManager settingsManager = SettingsManager.getInstance();
        if (settingsManager != null) {
            settingsManager = settingsManager.getReproConfigurations();
            WeakReference weakReference = ((Plugin)weakReference).contextWeakReference;
            if (settingsManager != null && weakReference != null) {
                com.instabug.bug.b.a((Context)weakReference.get(), (IBGSdkCoreEvent)new IBGSdkCoreEvent.ReproState(settingsManager.getModesMap()));
            }
        }
    }

    private void unSubscribeFromCoreEvents() {
        BugPlugin bugPlugin = bugPlugin.disposables;
        if (bugPlugin != null) {
            bugPlugin.dispose();
        }
    }

    private IBGCompositeDisposable getOrCreateCompositeDisposables() {
        IBGCompositeDisposable iBGCompositeDisposable = this.disposables;
        if (iBGCompositeDisposable == null) {
            IBGCompositeDisposable iBGCompositeDisposable2;
            iBGCompositeDisposable = iBGCompositeDisposable2;
            iBGCompositeDisposable2 = new IBGCompositeDisposable();
            this.disposables = iBGCompositeDisposable;
        }
        return iBGCompositeDisposable;
    }

    public void init(Context context) {
        Context context2 = context;
        this.initInvocationManager();
        com.instabug.bug.di.a.e().d();
        com.instabug.bug.di.a.i().evaluate((ReproConfigurationsProvider)com.instabug.bug.di.a.e());
        com.instabug.bug.di.a.j().addWatcher(4);
        com.instabug.bug.di.a.f().addWatcher(4);
        c.c(context2);
        super.init(context2);
    }

    public void wake() {
        com.instabug.bug.di.a.j().consentOnCleansing(4);
        com.instabug.bug.di.a.f().consentOnCleansing(4);
    }

    public void sleep() {
    }

    public void initDefaultPromptOptionAvailabilityState() {
        f.c();
    }

    public ArrayList<PluginPromptOption> getPromptOptions() {
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null && weakReference.get() != null) {
            return f.a((Context)this.contextWeakReference.get());
        }
        return new ArrayList<PluginPromptOption>();
    }

    @Nullable
    public ArrayList<PluginPromptOption> getPluginOptions(boolean bl) {
        InstabugSDKLogger.d((String)"IBG-BR", (String)"[BugPlugin#getPluginOptions] Getting plugin options");
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null && weakReference.get() != null) {
            return f.a(bl, (Context)this.contextWeakReference.get());
        }
        InstabugSDKLogger.d((String)"IBG-BR", (String)"[BugPlugin#getPluginOptions] No options, returning null");
        return null;
    }

    public boolean isFeatureEnabled() {
        return InstabugCore.isFeatureEnabled((String)"BUG_REPORTING");
    }

    public void stop() {
        BugPlugin bugPlugin = this;
        f.g();
        bugPlugin.unSubscribeFromCoreEvents();
        bugPlugin.unsubscribeFromMappedTokenChangedEvents();
        b.g().o();
        ScreenRecordingServiceEventBus.unregisterHandler((String)SCREEN_RECORDING_EVENT_NAME);
    }

    public void start(Context context) {
        if (Instabug.isEnabled() && com.instabug.bug.settings.b.h().q() && com.instabug.bug.settings.b.h().o() != 2) {
            new com.instabug.bug.onboardingbugreporting.utils.b().a();
        }
        BugPlugin bugPlugin = this;
        this.loadAndApplyCachedReproConfigurations();
        f.b(context);
        bugPlugin.subscribeOnCoreEvents();
        bugPlugin.subscribeOnMappedTokenChangedEvent();
        com.instabug.bug.network.b.b().start();
        b.g().m();
        bugPlugin.retrieveIntentFromPermissionsActivity();
    }

    public void retrieveIntentFromPermissionsActivity() {
        ScreenRecordingServiceEventBus.registerHandler((String)SCREEN_RECORDING_EVENT_NAME, screenRecordingServiceData -> {
            ScreenRecordingServiceData screenRecordingServiceData2 = screenRecordingServiceData;
            Context context = screenRecordingServiceData2.getContext();
            if (screenRecordingServiceData2.getResultOk() != null && screenRecordingServiceData.isSent() != null && context != null && screenRecordingServiceData.getMediaProjectionIntent() != null) {
                ScreenRecordingServiceData screenRecordingServiceData3 = screenRecordingServiceData;
                int n2 = screenRecordingServiceData3.getResultOk();
                Intent intent = screenRecordingServiceData3.getMediaProjectionIntent();
                screenRecordingServiceData = ScreenRecordingService.a(screenRecordingServiceData.getContext(), n2, intent, screenRecordingServiceData.isSent());
                if (Build.VERSION.SDK_INT >= 29) {
                    context.startForegroundService((Intent)screenRecordingServiceData);
                } else {
                    context.startService((Intent)screenRecordingServiceData);
                }
            }
        });
    }

    public long getLastActivityTime() {
        return com.instabug.bug.settings.b.h().i();
    }

    public void onLocaleChanged(Locale locale, Locale locale2) {
        super.onLocaleChanged(locale, locale2);
        a.b().start();
    }
}

