/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.types;

import com.ing.data.cassandra.jdbc.types.AbstractJdbcType;
import com.ing.data.cassandra.jdbc.types.MarshalException;
import java.nio.ByteBuffer;

public class JdbcBoolean
extends AbstractJdbcType<Boolean> {
    public static final JdbcBoolean INSTANCE = new JdbcBoolean();
    private static final int BOOLEAN_PRECISION = 5;

    JdbcBoolean() {
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public int getScale(Boolean obj) {
        return 0;
    }

    @Override
    public int getPrecision(Boolean obj) {
        return 5;
    }

    @Override
    public boolean isCurrency() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public String toString(Boolean obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    @Override
    public boolean needsQuotes() {
        return false;
    }

    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return Boolean.FALSE.toString();
        }
        if (bytes.remaining() != 1) {
            throw new MarshalException("A boolean is stored in exactly 1 byte, but found: " + bytes.remaining());
        }
        byte value = bytes.get(bytes.position());
        if (value == 0) {
            return Boolean.FALSE.toString();
        }
        return Boolean.TRUE.toString();
    }

    @Override
    public Class<Boolean> getType() {
        return Boolean.class;
    }

    @Override
    public int getJdbcType() {
        return 16;
    }

    @Override
    public Boolean compose(Object value) {
        return (Boolean)value;
    }

    @Override
    public Object decompose(Boolean value) {
        return value;
    }
}

