/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.google.gson.reflect.TypeToken;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.ApiResponse;
import com.infobip.Configuration;
import com.infobip.Pair;
import com.infobip.model.EmailLogsResult;
import com.infobip.model.EmailReportsResult;
import com.infobip.model.EmailSendResponse;
import java.io.File;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class SendEmailApi {
    private ApiClient localVarApiClient;

    public SendEmailApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SendEmailApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getEmailDeliveryReportsCall(String bulkId, String messageId, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/email/1/reports";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (bulkId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("bulkId", bulkId));
        }
        if (messageId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("messageId", messageId));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getEmailDeliveryReportsValidateBeforeCall(String bulkId, String messageId, Integer limit, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getEmailDeliveryReportsCall(bulkId, messageId, limit, _callback);
        return localVarCall;
    }

    public EmailReportsResult getEmailDeliveryReports(String bulkId, String messageId, Integer limit) throws ApiException {
        ApiResponse<EmailReportsResult> localVarResp = this.getEmailDeliveryReportsWithHttpInfo(bulkId, messageId, limit);
        return localVarResp.getData();
    }

    public ApiResponse<EmailReportsResult> getEmailDeliveryReportsWithHttpInfo(String bulkId, String messageId, Integer limit) throws ApiException {
        Call localVarCall = this.getEmailDeliveryReportsValidateBeforeCall(bulkId, messageId, limit, null);
        Type localVarReturnType = new TypeToken<EmailReportsResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getEmailDeliveryReportsAsync(String bulkId, String messageId, Integer limit, ApiCallback<EmailReportsResult> _callback) throws ApiException {
        Call localVarCall = this.getEmailDeliveryReportsValidateBeforeCall(bulkId, messageId, limit, _callback);
        Type localVarReturnType = new TypeToken<EmailReportsResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getEmailLogsCall(String from, String to, List<String> bulkId, List<String> messageId, String generalStatus, OffsetDateTime sentSince, OffsetDateTime sentUntil, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/email/1/logs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (bulkId != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bulkId", bulkId));
        }
        if (messageId != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "messageId", messageId));
        }
        if (generalStatus != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("generalStatus", generalStatus));
        }
        if (sentSince != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sentSince", sentSince));
        }
        if (sentUntil != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sentUntil", sentUntil));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/xml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getEmailLogsValidateBeforeCall(String from, String to, List<String> bulkId, List<String> messageId, String generalStatus, OffsetDateTime sentSince, OffsetDateTime sentUntil, Integer limit, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getEmailLogsCall(from, to, bulkId, messageId, generalStatus, sentSince, sentUntil, limit, _callback);
        return localVarCall;
    }

    public EmailLogsResult getEmailLogs(String from, String to, List<String> bulkId, List<String> messageId, String generalStatus, OffsetDateTime sentSince, OffsetDateTime sentUntil, Integer limit) throws ApiException {
        ApiResponse<EmailLogsResult> localVarResp = this.getEmailLogsWithHttpInfo(from, to, bulkId, messageId, generalStatus, sentSince, sentUntil, limit);
        return localVarResp.getData();
    }

    public ApiResponse<EmailLogsResult> getEmailLogsWithHttpInfo(String from, String to, List<String> bulkId, List<String> messageId, String generalStatus, OffsetDateTime sentSince, OffsetDateTime sentUntil, Integer limit) throws ApiException {
        Call localVarCall = this.getEmailLogsValidateBeforeCall(from, to, bulkId, messageId, generalStatus, sentSince, sentUntil, limit, null);
        Type localVarReturnType = new TypeToken<EmailLogsResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getEmailLogsAsync(String from, String to, List<String> bulkId, List<String> messageId, String generalStatus, OffsetDateTime sentSince, OffsetDateTime sentUntil, Integer limit, ApiCallback<EmailLogsResult> _callback) throws ApiException {
        Call localVarCall = this.getEmailLogsValidateBeforeCall(from, to, bulkId, messageId, generalStatus, sentSince, sentUntil, limit, _callback);
        Type localVarReturnType = new TypeToken<EmailLogsResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call sendEmailCall(String from, String to, String subject, String cc, String bcc, String text, String bulkId, String messageId, Integer templateid, File attachment, File inlineImage, String HTML, String replyto, String defaultplaceholders, Boolean preserverecipients, String trackingUrl, Boolean trackclicks, Boolean trackopens, Boolean track, String callbackData, Boolean intermediateReport, String notifyUrl, String notifyContentType, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/email/2/send";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (from != null) {
            localVarFormParams.put("from", from);
        }
        if (to != null) {
            localVarFormParams.put("to", to);
        }
        if (cc != null) {
            localVarFormParams.put("cc", cc);
        }
        if (bcc != null) {
            localVarFormParams.put("bcc", bcc);
        }
        if (subject != null) {
            localVarFormParams.put("subject", subject);
        }
        if (text != null) {
            localVarFormParams.put("text", text);
        }
        if (bulkId != null) {
            localVarFormParams.put("bulkId", bulkId);
        }
        if (messageId != null) {
            localVarFormParams.put("messageId", messageId);
        }
        if (templateid != null) {
            localVarFormParams.put("templateid", templateid);
        }
        if (attachment != null) {
            localVarFormParams.put("attachment", attachment);
        }
        if (inlineImage != null) {
            localVarFormParams.put("inlineImage", inlineImage);
        }
        if (HTML != null) {
            localVarFormParams.put("HTML", HTML);
        }
        if (replyto != null) {
            localVarFormParams.put("replyto", replyto);
        }
        if (defaultplaceholders != null) {
            localVarFormParams.put("defaultplaceholders", defaultplaceholders);
        }
        if (preserverecipients != null) {
            localVarFormParams.put("preserverecipients", preserverecipients);
        }
        if (trackingUrl != null) {
            localVarFormParams.put("trackingUrl", trackingUrl);
        }
        if (trackclicks != null) {
            localVarFormParams.put("trackclicks", trackclicks);
        }
        if (trackopens != null) {
            localVarFormParams.put("trackopens", trackopens);
        }
        if (track != null) {
            localVarFormParams.put("track", track);
        }
        if (callbackData != null) {
            localVarFormParams.put("callbackData", callbackData);
        }
        if (intermediateReport != null) {
            localVarFormParams.put("intermediateReport", intermediateReport);
        }
        if (notifyUrl != null) {
            localVarFormParams.put("notifyUrl", notifyUrl);
        }
        if (notifyContentType != null) {
            localVarFormParams.put("notifyContentType", notifyContentType);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/xml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call sendEmailValidateBeforeCall(String from, String to, String subject, String cc, String bcc, String text, String bulkId, String messageId, Integer templateid, File attachment, File inlineImage, String HTML, String replyto, String defaultplaceholders, Boolean preserverecipients, String trackingUrl, Boolean trackclicks, Boolean trackopens, Boolean track, String callbackData, Boolean intermediateReport, String notifyUrl, String notifyContentType, ApiCallback _callback) throws ApiException {
        if (from == null) {
            throw new ApiException("Missing the required parameter 'from' when calling sendEmail(Async)");
        }
        if (to == null) {
            throw new ApiException("Missing the required parameter 'to' when calling sendEmail(Async)");
        }
        if (subject == null) {
            throw new ApiException("Missing the required parameter 'subject' when calling sendEmail(Async)");
        }
        Call localVarCall = this.sendEmailCall(from, to, subject, cc, bcc, text, bulkId, messageId, templateid, attachment, inlineImage, HTML, replyto, defaultplaceholders, preserverecipients, trackingUrl, trackclicks, trackopens, track, callbackData, intermediateReport, notifyUrl, notifyContentType, _callback);
        return localVarCall;
    }

    private ApiResponse<EmailSendResponse> sendEmailWithHttpInfo(String from, String to, String subject, String cc, String bcc, String text, String bulkId, String messageId, Integer templateid, File attachment, File inlineImage, String HTML, String replyto, String defaultplaceholders, Boolean preserverecipients, String trackingUrl, Boolean trackclicks, Boolean trackopens, Boolean track, String callbackData, Boolean intermediateReport, String notifyUrl, String notifyContentType) throws ApiException {
        Call localVarCall = this.sendEmailValidateBeforeCall(from, to, subject, cc, bcc, text, bulkId, messageId, templateid, attachment, inlineImage, HTML, replyto, defaultplaceholders, preserverecipients, trackingUrl, trackclicks, trackopens, track, callbackData, intermediateReport, notifyUrl, notifyContentType, null);
        Type localVarReturnType = new TypeToken<EmailSendResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call sendEmailAsync(String from, String to, String subject, String cc, String bcc, String text, String bulkId, String messageId, Integer templateid, File attachment, File inlineImage, String HTML, String replyto, String defaultplaceholders, Boolean preserverecipients, String trackingUrl, Boolean trackclicks, Boolean trackopens, Boolean track, String callbackData, Boolean intermediateReport, String notifyUrl, String notifyContentType, ApiCallback<EmailSendResponse> _callback) throws ApiException {
        Call localVarCall = this.sendEmailValidateBeforeCall(from, to, subject, cc, bcc, text, bulkId, messageId, templateid, attachment, inlineImage, HTML, replyto, defaultplaceholders, preserverecipients, trackingUrl, trackclicks, trackopens, track, callbackData, intermediateReport, notifyUrl, notifyContentType, _callback);
        Type localVarReturnType = new TypeToken<EmailSendResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIsendEmailRequest sendEmail(String from, String to, String subject) {
        return new APIsendEmailRequest(from, to, subject);
    }

    public class APIsendEmailRequest {
        private final String from;
        private final String to;
        private final String subject;
        private String cc;
        private String bcc;
        private String text;
        private String bulkId;
        private String messageId;
        private Integer templateid;
        private File attachment;
        private File inlineImage;
        private String HTML;
        private String replyto;
        private String defaultplaceholders;
        private Boolean preserverecipients;
        private String trackingUrl;
        private Boolean trackclicks;
        private Boolean trackopens;
        private Boolean track;
        private String callbackData;
        private Boolean intermediateReport;
        private String notifyUrl;
        private String notifyContentType;

        private APIsendEmailRequest(String from, String to, String subject) {
            this.from = from;
            this.to = to;
            this.subject = subject;
        }

        public APIsendEmailRequest cc(String cc) {
            this.cc = cc;
            return this;
        }

        public APIsendEmailRequest bcc(String bcc) {
            this.bcc = bcc;
            return this;
        }

        public APIsendEmailRequest text(String text) {
            this.text = text;
            return this;
        }

        public APIsendEmailRequest bulkId(String bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public APIsendEmailRequest messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public APIsendEmailRequest templateid(Integer templateid) {
            this.templateid = templateid;
            return this;
        }

        public APIsendEmailRequest attachment(File attachment) {
            this.attachment = attachment;
            return this;
        }

        public APIsendEmailRequest inlineImage(File inlineImage) {
            this.inlineImage = inlineImage;
            return this;
        }

        public APIsendEmailRequest HTML(String HTML) {
            this.HTML = HTML;
            return this;
        }

        public APIsendEmailRequest replyto(String replyto) {
            this.replyto = replyto;
            return this;
        }

        public APIsendEmailRequest defaultplaceholders(String defaultplaceholders) {
            this.defaultplaceholders = defaultplaceholders;
            return this;
        }

        public APIsendEmailRequest preserverecipients(Boolean preserverecipients) {
            this.preserverecipients = preserverecipients;
            return this;
        }

        public APIsendEmailRequest trackingUrl(String trackingUrl) {
            this.trackingUrl = trackingUrl;
            return this;
        }

        public APIsendEmailRequest trackclicks(Boolean trackclicks) {
            this.trackclicks = trackclicks;
            return this;
        }

        public APIsendEmailRequest trackopens(Boolean trackopens) {
            this.trackopens = trackopens;
            return this;
        }

        public APIsendEmailRequest track(Boolean track) {
            this.track = track;
            return this;
        }

        public APIsendEmailRequest callbackData(String callbackData) {
            this.callbackData = callbackData;
            return this;
        }

        public APIsendEmailRequest intermediateReport(Boolean intermediateReport) {
            this.intermediateReport = intermediateReport;
            return this;
        }

        public APIsendEmailRequest notifyUrl(String notifyUrl) {
            this.notifyUrl = notifyUrl;
            return this;
        }

        public APIsendEmailRequest notifyContentType(String notifyContentType) {
            this.notifyContentType = notifyContentType;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SendEmailApi.this.sendEmailCall(this.from, this.to, this.subject, this.cc, this.bcc, this.text, this.bulkId, this.messageId, this.templateid, this.attachment, this.inlineImage, this.HTML, this.replyto, this.defaultplaceholders, this.preserverecipients, this.trackingUrl, this.trackclicks, this.trackopens, this.track, this.callbackData, this.intermediateReport, this.notifyUrl, this.notifyContentType, _callback);
        }

        public EmailSendResponse execute() throws ApiException {
            ApiResponse localVarResp = SendEmailApi.this.sendEmailWithHttpInfo(this.from, this.to, this.subject, this.cc, this.bcc, this.text, this.bulkId, this.messageId, this.templateid, this.attachment, this.inlineImage, this.HTML, this.replyto, this.defaultplaceholders, this.preserverecipients, this.trackingUrl, this.trackclicks, this.trackopens, this.track, this.callbackData, this.intermediateReport, this.notifyUrl, this.notifyContentType);
            return (EmailSendResponse)localVarResp.getData();
        }

        public ApiResponse<EmailSendResponse> executeWithHttpInfo() throws ApiException {
            return SendEmailApi.this.sendEmailWithHttpInfo(this.from, this.to, this.subject, this.cc, this.bcc, this.text, this.bulkId, this.messageId, this.templateid, this.attachment, this.inlineImage, this.HTML, this.replyto, this.defaultplaceholders, this.preserverecipients, this.trackingUrl, this.trackclicks, this.trackopens, this.track, this.callbackData, this.intermediateReport, this.notifyUrl, this.notifyContentType);
        }

        public Call executeAsync(ApiCallback<EmailSendResponse> _callback) throws ApiException {
            return SendEmailApi.this.sendEmailAsync(this.from, this.to, this.subject, this.cc, this.bcc, this.text, this.bulkId, this.messageId, this.templateid, this.attachment, this.inlineImage, this.HTML, this.replyto, this.defaultplaceholders, this.preserverecipients, this.trackingUrl, this.trackclicks, this.trackopens, this.track, this.callbackData, this.intermediateReport, this.notifyUrl, this.notifyContentType, _callback);
        }
    }
}

