/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.service;

import com.influxdb.client.domain.Check;
import com.influxdb.client.domain.CheckPatch;
import com.influxdb.client.domain.Checks;
import com.influxdb.client.domain.FluxResponse;
import com.influxdb.client.domain.LabelMapping;
import com.influxdb.client.domain.LabelResponse;
import com.influxdb.client.domain.LabelsResponse;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface ChecksService {
    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/checks")
    public Call<Check> createCheck(@Body Check var1);

    @DELETE(value="api/v2/checks/{checkID}")
    public Call<Void> deleteChecksID(@Path(value="checkID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @DELETE(value="api/v2/checks/{checkID}/labels/{labelID}")
    public Call<Void> deleteChecksIDLabelsID(@Path(value="checkID") String var1, @Path(value="labelID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @GET(value="api/v2/checks")
    public Call<Checks> getChecks(@Query(value="orgID") String var1, @Header(value="Zap-Trace-Span") String var2, @Query(value="offset") Integer var3, @Query(value="limit") Integer var4);

    @GET(value="api/v2/checks/{checkID}")
    public Call<Check> getChecksID(@Path(value="checkID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/checks/{checkID}/labels")
    public Call<LabelsResponse> getChecksIDLabels(@Path(value="checkID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/checks/{checkID}/query")
    public Call<FluxResponse> getChecksIDQuery(@Path(value="checkID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @Headers(value={"Content-Type:application/json"})
    @PATCH(value="api/v2/checks/{checkID}")
    public Call<Check> patchChecksID(@Path(value="checkID") String var1, @Body CheckPatch var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/checks/{checkID}/labels")
    public Call<LabelResponse> postChecksIDLabels(@Path(value="checkID") String var1, @Body LabelMapping var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @PUT(value="api/v2/checks/{checkID}")
    public Call<Check> putChecksID(@Path(value="checkID") String var1, @Body Check var2, @Header(value="Zap-Trace-Span") String var3);
}

