/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;

public class GzipInterceptor
implements Interceptor {
    private static final Pattern CONTENT_PATTERN = Pattern.compile(".*/write", 2);
    private static final Pattern ACCEPT_PATTERN = Pattern.compile(".*/query", 2);
    private AtomicBoolean enabled = new AtomicBoolean(false);

    @Nonnull
    public Response intercept(@Nonnull Interceptor.Chain chain) throws IOException {
        Request enhancedRequest;
        Request request = chain.request();
        RequestBody body = request.body();
        if (!this.enabled.get()) {
            Request.Builder builder = request.newBuilder();
            builder = this.addHeader(request, builder, "Accept-Encoding", "identity");
            enhancedRequest = builder.build();
        } else if (CONTENT_PATTERN.matcher(request.url().encodedPath()).matches()) {
            Request.Builder builder = request.newBuilder();
            if (body == null || request.header("Content-Encoding") != null) {
                enhancedRequest = builder.build();
            } else {
                builder = this.addHeader(request, builder, "Content-Encoding", "gzip");
                builder = this.addHeader(request, builder, "Accept-Encoding", "identity");
                enhancedRequest = builder.method(request.method(), this.gzip(body)).build();
            }
        } else if (ACCEPT_PATTERN.matcher(request.url().encodedPath()).matches()) {
            enhancedRequest = request;
        } else {
            Request.Builder builder = request.newBuilder();
            builder = this.addHeader(request, builder, "Accept-Encoding", "identity");
            enhancedRequest = builder.build();
        }
        return chain.proceed(enhancedRequest);
    }

    public void enableGzip() {
        this.enabled.set(true);
    }

    public boolean isEnabledGzip() {
        return this.enabled.get();
    }

    public void disableGzip() {
        this.enabled.set(false);
    }

    @Nonnull
    private Request.Builder addHeader(@Nonnull Request request, @Nonnull Request.Builder builder, @Nonnull String headerName, @Nonnull String headerValue) {
        if (request.header(headerName) != null) {
            return builder;
        }
        return builder.header(headerName, headerValue);
    }

    @Nonnull
    private RequestBody gzip(final @Nonnull RequestBody body) {
        return new RequestBody(){

            public MediaType contentType() {
                return body.contentType();
            }

            public long contentLength() {
                return -1L;
            }

            public void writeTo(@Nonnull BufferedSink sink) throws IOException {
                BufferedSink gzipSink = Okio.buffer((Sink)new GzipSink((Sink)sink));
                body.writeTo(gzipSink);
                gzipSink.close();
            }
        };
    }
}

