/*
 * InfluxDB OSS API Service
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint. 
 *
 * OpenAPI spec version: 2.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.influxdb.client.domain;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.CheckStatusLevel;
import com.influxdb.client.domain.ThresholdBase;
import java.io.IOException;

/**
 * RangeThreshold
 */

public class RangeThreshold extends Threshold {
  /**
   * Gets or Sets type
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    RANGE("range");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String text) {
      for (TypeEnum b : TypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return TypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type = TypeEnum.RANGE;

  public static final String SERIALIZED_NAME_MIN = "min";
  @SerializedName(SERIALIZED_NAME_MIN)
  private Float min;

  public static final String SERIALIZED_NAME_MAX = "max";
  @SerializedName(SERIALIZED_NAME_MAX)
  private Float max;

  public static final String SERIALIZED_NAME_WITHIN = "within";
  @SerializedName(SERIALIZED_NAME_WITHIN)
  private Boolean within;

   /**
   * Get type
   * @return type
  **/
  public TypeEnum getType() {
    return type;
  }

  public RangeThreshold min(Float min) {
    this.min = min;
    return this;
  }

   /**
   * Get min
   * @return min
  **/
  public Float getMin() {
    return min;
  }

  public void setMin(Float min) {
    this.min = min;
  }

  public RangeThreshold max(Float max) {
    this.max = max;
    return this;
  }

   /**
   * Get max
   * @return max
  **/
  public Float getMax() {
    return max;
  }

  public void setMax(Float max) {
    this.max = max;
  }

  public RangeThreshold within(Boolean within) {
    this.within = within;
    return this;
  }

   /**
   * Get within
   * @return within
  **/
  public Boolean getWithin() {
    return within;
  }

  public void setWithin(Boolean within) {
    this.within = within;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RangeThreshold rangeThreshold = (RangeThreshold) o;
    return Objects.equals(this.type, rangeThreshold.type) &&
        Objects.equals(this.min, rangeThreshold.min) &&
        Objects.equals(this.max, rangeThreshold.max) &&
        Objects.equals(this.within, rangeThreshold.within) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, min, max, within, super.hashCode());
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RangeThreshold {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    min: ").append(toIndentedString(min)).append("\n");
    sb.append("    max: ").append(toIndentedString(max)).append("\n");
    sb.append("    within: ").append(toIndentedString(within)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

