/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.internal;

import com.influxdb.client.ScraperTargetsApi;
import com.influxdb.client.domain.AddResourceMemberRequestBody;
import com.influxdb.client.domain.Label;
import com.influxdb.client.domain.LabelMapping;
import com.influxdb.client.domain.LabelResponse;
import com.influxdb.client.domain.LabelsResponse;
import com.influxdb.client.domain.Organization;
import com.influxdb.client.domain.ResourceMember;
import com.influxdb.client.domain.ResourceMembers;
import com.influxdb.client.domain.ResourceOwner;
import com.influxdb.client.domain.ResourceOwners;
import com.influxdb.client.domain.ScraperTargetRequest;
import com.influxdb.client.domain.ScraperTargetResponse;
import com.influxdb.client.domain.ScraperTargetResponses;
import com.influxdb.client.domain.User;
import com.influxdb.client.service.ScraperTargetsService;
import com.influxdb.internal.AbstractRestClient;
import com.influxdb.utils.Arguments;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import retrofit2.Call;

final class ScraperTargetsApiImpl
extends AbstractRestClient
implements ScraperTargetsApi {
    private static final Logger LOG = Logger.getLogger(ScraperTargetsApiImpl.class.getName());
    private final ScraperTargetsService service;

    ScraperTargetsApiImpl(@Nonnull ScraperTargetsService service) {
        Arguments.checkNotNull((Object)service, (String)"service");
        this.service = service;
    }

    @Override
    @Nonnull
    public ScraperTargetResponse createScraperTarget(@Nonnull ScraperTargetRequest scraperTargetRequest) {
        Arguments.checkNotNull((Object)scraperTargetRequest, (String)"scraperTargetRequest");
        Call<ScraperTargetResponse> call = this.service.postScrapers(scraperTargetRequest, null);
        return (ScraperTargetResponse)this.execute(call);
    }

    @Override
    @Nonnull
    public ScraperTargetResponse createScraperTarget(@Nonnull String name, @Nonnull String url, @Nonnull String bucketID, @Nonnull String orgID) {
        Arguments.checkNonEmpty((String)name, (String)"name");
        Arguments.checkNonEmpty((String)url, (String)"url");
        Arguments.checkNonEmpty((String)bucketID, (String)"bucketID");
        Arguments.checkNonEmpty((String)orgID, (String)" orgID");
        ScraperTargetRequest scraperTarget = new ScraperTargetRequest();
        scraperTarget.setName(name);
        scraperTarget.setUrl(url);
        scraperTarget.setBucketID(bucketID);
        scraperTarget.setOrgID(orgID);
        return this.createScraperTarget(scraperTarget);
    }

    @Override
    @Nonnull
    public ScraperTargetResponse updateScraperTarget(@Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNotNull((Object)scraperTargetResponse, (String)"scraperTarget");
        return this.updateScraperTarget(scraperTargetResponse.getId(), scraperTargetResponse);
    }

    @Override
    @Nonnull
    public ScraperTargetResponse updateScraperTarget(@Nonnull String scraperTargetID, @Nonnull ScraperTargetRequest scraperTargetRequest) {
        Arguments.checkNonEmpty((String)scraperTargetID, (String)"scraperTargetID");
        Arguments.checkNotNull((Object)scraperTargetRequest, (String)"scraperTargetRequest");
        Call<ScraperTargetResponse> call = this.service.patchScrapersID(scraperTargetID, scraperTargetRequest, null);
        return (ScraperTargetResponse)this.execute(call);
    }

    @Override
    public void deleteScraperTarget(@Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNotNull((Object)scraperTargetResponse, (String)"scraperTarget");
        this.deleteScraperTarget(scraperTargetResponse.getId());
    }

    @Override
    public void deleteScraperTarget(@Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty((String)scraperTargetID, (String)"scraperTargetID");
        Call<Void> call = this.service.deleteScrapersID(scraperTargetID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public ScraperTargetResponse cloneScraperTarget(@Nonnull String clonedName, @Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty((String)clonedName, (String)"clonedName");
        Arguments.checkNonEmpty((String)scraperTargetID, (String)"scraperTargetID");
        ScraperTargetResponse scraperTarget = this.findScraperTargetByID(scraperTargetID);
        return this.cloneScraperTarget(clonedName, scraperTarget);
    }

    @Override
    @Nonnull
    public ScraperTargetResponse cloneScraperTarget(@Nonnull String clonedName, @Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNonEmpty((String)clonedName, (String)"clonedName");
        Arguments.checkNotNull((Object)scraperTargetResponse, (String)"scraperTarget");
        ScraperTargetRequest cloned = new ScraperTargetRequest();
        cloned.setName(clonedName);
        cloned.setUrl(scraperTargetResponse.getUrl());
        cloned.setOrgID(scraperTargetResponse.getOrgID());
        cloned.setBucketID(scraperTargetResponse.getBucketID());
        ScraperTargetResponse created = this.createScraperTarget(cloned);
        this.getLabels(scraperTargetResponse).forEach(label -> this.addLabel((Label)label, created));
        return created;
    }

    @Override
    @Nonnull
    public ScraperTargetResponse findScraperTargetByID(@Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty((String)scraperTargetID, (String)"scraperTargetID");
        Call<ScraperTargetResponse> call = this.service.getScrapersID(scraperTargetID, null);
        return (ScraperTargetResponse)this.execute(call);
    }

    @Override
    @Nonnull
    public List<ScraperTargetResponse> findScraperTargets() {
        return this.findScraperTargetsByOrgId(null);
    }

    @Override
    @Nonnull
    public List<ScraperTargetResponse> findScraperTargetsByOrg(@Nonnull Organization organization) {
        Arguments.checkNotNull((Object)organization, (String)"organization");
        return this.findScraperTargetsByOrgId(organization.getId());
    }

    @Override
    @Nonnull
    public List<ScraperTargetResponse> findScraperTargetsByOrgId(@Nullable String orgID) {
        Call<ScraperTargetResponses> call = this.service.getScrapers(null, null, null, orgID, null);
        ScraperTargetResponses responses = (ScraperTargetResponses)this.execute(call);
        LOG.log(Level.FINEST, "findScraperTargets found: {0}", responses);
        return responses.getConfigurations();
    }

    @Override
    @Nonnull
    public List<ResourceMember> getMembers(@Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNotNull((Object)scraperTargetResponse, (String)"scraperTarget");
        return this.getMembers(scraperTargetResponse.getId());
    }

    @Override
    @Nonnull
    public List<ResourceMember> getMembers(@Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty((String)scraperTargetID, (String)"scraperTargetID");
        Call<ResourceMembers> call = this.service.getScrapersIDMembers(scraperTargetID, null);
        ResourceMembers resourceMembers = (ResourceMembers)this.execute(call);
        LOG.log(Level.FINEST, "findScraperTargetMembers found: {0}", resourceMembers);
        return resourceMembers.getUsers();
    }

    @Override
    @Nonnull
    public ResourceMember addMember(@Nonnull User member, @Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNotNull((Object)scraperTargetResponse, (String)"scraperTarget");
        Arguments.checkNotNull((Object)member, (String)"member");
        return this.addMember(member.getId(), scraperTargetResponse.getId());
    }

    @Override
    @Nonnull
    public ResourceMember addMember(@Nonnull String memberID, @Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty((String)memberID, (String)"Member ID");
        Arguments.checkNonEmpty((String)scraperTargetID, (String)"scraperTargetID");
        AddResourceMemberRequestBody user = new AddResourceMemberRequestBody();
        user.setId(memberID);
        Call<ResourceMember> call = this.service.postScrapersIDMembers(scraperTargetID, user, null);
        return (ResourceMember)this.execute(call);
    }

    @Override
    public void deleteMember(@Nonnull User member, @Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNotNull((Object)scraperTargetResponse, (String)"scraperTarget");
        Arguments.checkNotNull((Object)member, (String)"member");
        this.deleteMember(member.getId(), scraperTargetResponse.getId());
    }

    @Override
    public void deleteMember(@Nonnull String memberID, @Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty((String)memberID, (String)"Member ID");
        Arguments.checkNonEmpty((String)scraperTargetID, (String)"scraperTargetID");
        Call<Void> call = this.service.deleteScrapersIDMembersID(memberID, scraperTargetID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<ResourceOwner> getOwners(@Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNotNull((Object)scraperTargetResponse, (String)"scraperTarget");
        return this.getOwners(scraperTargetResponse.getId());
    }

    @Override
    @Nonnull
    public List<ResourceOwner> getOwners(@Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty((String)scraperTargetID, (String)"scraperTargetID");
        Call<ResourceOwners> call = this.service.getScrapersIDOwners(scraperTargetID, null);
        ResourceOwners resourceMembers = (ResourceOwners)this.execute(call);
        LOG.log(Level.FINEST, "findScraperTargetOwners found: {0}", resourceMembers);
        return resourceMembers.getUsers();
    }

    @Override
    @Nonnull
    public ResourceOwner addOwner(@Nonnull User owner, @Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNotNull((Object)scraperTargetResponse, (String)"scraperTarget");
        Arguments.checkNotNull((Object)owner, (String)"owner");
        return this.addOwner(owner.getId(), scraperTargetResponse.getId());
    }

    @Override
    @Nonnull
    public ResourceOwner addOwner(@Nonnull String ownerID, @Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty((String)ownerID, (String)"Owner ID");
        Arguments.checkNonEmpty((String)scraperTargetID, (String)"scraperTargetID");
        AddResourceMemberRequestBody user = new AddResourceMemberRequestBody();
        user.setId(ownerID);
        Call<ResourceOwner> call = this.service.postScrapersIDOwners(scraperTargetID, user, null);
        return (ResourceOwner)this.execute(call);
    }

    @Override
    public void deleteOwner(@Nonnull User owner, @Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNotNull((Object)scraperTargetResponse, (String)"scraperTarget");
        Arguments.checkNotNull((Object)owner, (String)"owner");
        this.deleteOwner(owner.getId(), scraperTargetResponse.getId());
    }

    @Override
    public void deleteOwner(@Nonnull String ownerID, @Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty((String)ownerID, (String)"Owner ID");
        Arguments.checkNonEmpty((String)scraperTargetID, (String)"scraperTargetID");
        Call<Void> call = this.service.deleteScrapersIDOwnersID(ownerID, scraperTargetID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNotNull((Object)scraperTargetResponse, (String)"scraperTarget");
        return this.getLabels(scraperTargetResponse.getId());
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty((String)scraperTargetID, (String)"scraperTargetID");
        Call<LabelsResponse> call = this.service.getScrapersIDLabels(scraperTargetID, null);
        return ((LabelsResponse)this.execute(call)).getLabels();
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull Label label, @Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNotNull((Object)label, (String)"label");
        Arguments.checkNotNull((Object)scraperTargetResponse, (String)"scraperTarget");
        return this.addLabel(label.getId(), scraperTargetResponse.getId());
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull String labelID, @Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty((String)labelID, (String)"labelID");
        Arguments.checkNonEmpty((String)scraperTargetID, (String)"scraperTargetID");
        LabelMapping labelMapping = new LabelMapping();
        labelMapping.setLabelID(labelID);
        Call<LabelResponse> call = this.service.postScrapersIDLabels(scraperTargetID, labelMapping, null);
        return (LabelResponse)this.execute(call);
    }

    @Override
    public void deleteLabel(@Nonnull Label label, @Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNotNull((Object)label, (String)"label");
        Arguments.checkNotNull((Object)scraperTargetResponse, (String)"scraperTarget");
        this.deleteLabel(label.getId(), scraperTargetResponse.getId());
    }

    @Override
    public void deleteLabel(@Nonnull String labelID, @Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty((String)labelID, (String)"labelID");
        Arguments.checkNonEmpty((String)scraperTargetID, (String)"scraperTargetID");
        Call<Void> call = this.service.deleteScrapersIDLabelsID(scraperTargetID, labelID, null);
        this.execute(call);
    }
}

