/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.annotations.SerializedName;
import com.influxdb.client.domain.AuthorizationUpdateRequest;
import com.influxdb.client.domain.Permission;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LegacyAuthorizationPostRequest
extends AuthorizationUpdateRequest {
    public static final String SERIALIZED_NAME_ORG_I_D = "orgID";
    @SerializedName(value="orgID")
    private String orgID;
    public static final String SERIALIZED_NAME_USER_I_D = "userID";
    @SerializedName(value="userID")
    private String userID;
    public static final String SERIALIZED_NAME_TOKEN = "token";
    @SerializedName(value="token")
    private String token;
    public static final String SERIALIZED_NAME_PERMISSIONS = "permissions";
    @SerializedName(value="permissions")
    private List<Permission> permissions = new ArrayList<Permission>();

    public LegacyAuthorizationPostRequest orgID(String orgID) {
        this.orgID = orgID;
        return this;
    }

    @ApiModelProperty(value="ID of org that authorization is scoped to.")
    public String getOrgID() {
        return this.orgID;
    }

    public void setOrgID(String orgID) {
        this.orgID = orgID;
    }

    public LegacyAuthorizationPostRequest userID(String userID) {
        this.userID = userID;
        return this;
    }

    @ApiModelProperty(value="ID of user that authorization is scoped to.")
    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public LegacyAuthorizationPostRequest token(String token) {
        this.token = token;
        return this;
    }

    @ApiModelProperty(value="Token (name) of the authorization")
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public LegacyAuthorizationPostRequest permissions(List<Permission> permissions) {
        this.permissions = permissions;
        return this;
    }

    public LegacyAuthorizationPostRequest addPermissionsItem(Permission permissionsItem) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<Permission>();
        }
        this.permissions.add(permissionsItem);
        return this;
    }

    @ApiModelProperty(value="List of permissions for an auth.  An auth must have at least one Permission.")
    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegacyAuthorizationPostRequest legacyAuthorizationPostRequest = (LegacyAuthorizationPostRequest)o;
        return Objects.equals(this.orgID, legacyAuthorizationPostRequest.orgID) && Objects.equals(this.userID, legacyAuthorizationPostRequest.userID) && Objects.equals(this.token, legacyAuthorizationPostRequest.token) && Objects.equals(this.permissions, legacyAuthorizationPostRequest.permissions) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.orgID, this.userID, this.token, this.permissions, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LegacyAuthorizationPostRequest {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    orgID: ").append(this.toIndentedString(this.orgID)).append("\n");
        sb.append("    userID: ").append(this.toIndentedString(this.userID)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

