/*
 * Influx OSS API Service
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint. 
 *
 * OpenAPI spec version: 2.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.influxdb.client.domain;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * Indicates whether decimal places should be enforced, and how many digits it should show.
 */
@ApiModel(description = "Indicates whether decimal places should be enforced, and how many digits it should show.")

public class DecimalPlaces {
  public static final String SERIALIZED_NAME_IS_ENFORCED = "isEnforced";
  @SerializedName(SERIALIZED_NAME_IS_ENFORCED)
  private Boolean isEnforced;

  public static final String SERIALIZED_NAME_DIGITS = "digits";
  @SerializedName(SERIALIZED_NAME_DIGITS)
  private Integer digits;

  public DecimalPlaces isEnforced(Boolean isEnforced) {
    this.isEnforced = isEnforced;
    return this;
  }

   /**
   * Indicates whether decimal point setting should be enforced
   * @return isEnforced
  **/
  @ApiModelProperty(value = "Indicates whether decimal point setting should be enforced")
  public Boolean getIsEnforced() {
    return isEnforced;
  }

  public void setIsEnforced(Boolean isEnforced) {
    this.isEnforced = isEnforced;
  }

  public DecimalPlaces digits(Integer digits) {
    this.digits = digits;
    return this;
  }

   /**
   * The number of digits after decimal to display
   * @return digits
  **/
  @ApiModelProperty(value = "The number of digits after decimal to display")
  public Integer getDigits() {
    return digits;
  }

  public void setDigits(Integer digits) {
    this.digits = digits;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DecimalPlaces decimalPlaces = (DecimalPlaces) o;
    return Objects.equals(this.isEnforced, decimalPlaces.isEnforced) &&
        Objects.equals(this.digits, decimalPlaces.digits);
  }

  @Override
  public int hashCode() {
    return Objects.hash(isEnforced, digits);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DecimalPlaces {\n");
    sb.append("    isEnforced: ").append(toIndentedString(isEnforced)).append("\n");
    sb.append("    digits: ").append(toIndentedString(digits)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

