/*
 * Decompiled with CFR 0.152.
 */
package com.indix.tools;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SSLTrustCA {
    private static final char[] KEYSTORE_DEFAULT_PASSWORD = "changeit".toCharArray();
    private static KeyStore keyStore;
    private static final Logger LOG;

    public static SSLContext trustLetsEncryptRootCA() {
        return SSLTrustCA.trustCa(SSLTrustCA.class.getResource("/ca/DSTRootCAX3.der"));
    }

    private static synchronized KeyStore initialize() throws GeneralSecurityException, IOException {
        if (keyStore == null) {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, KEYSTORE_DEFAULT_PASSWORD);
            SSLTrustCA.keyStore = keyStore;
        }
        return keyStore;
    }

    private static synchronized SSLContext trustCa(URL caFile) {
        try {
            Certificate crt;
            LOG.debug("Trusting CAFile: " + caFile.toExternalForm());
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            try (BufferedInputStream caInput = new BufferedInputStream(caFile.openStream());){
                crt = cf.generateCertificate(caInput);
            }
            String certName = ((X509Certificate)crt).getSubjectDN().getName();
            KeyStore keyStore = SSLTrustCA.initialize();
            keyStore.setCertificateEntry(certName, crt);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tmf.getTrustManagers(), null);
            SSLContext.setDefault(sslContext);
            return sslContext;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        LOG = LoggerFactory.getLogger(SSLTrustCA.class);
    }
}

