/*
 * Decompiled with CFR 0.152.
 */
package com.indix.httpClient.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.indix.exception.BadRequestException;
import com.indix.exception.IndixApiException;
import com.indix.exception.InternalServerException;
import com.indix.exception.PaymentRequiredException;
import com.indix.exception.TooManyRequestsException;
import com.indix.exception.UnauthorizedException;
import com.indix.httpClient.HttpClient;
import com.indix.httpClient.impl.ErrorResponse;
import com.indix.tools.SSLTrustCA;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

class HttpClientImpl
implements HttpClient {
    CloseableHttpClient closeableHttpClient;
    ObjectMapper objectMapper;

    public HttpClientImpl() {
        this(HttpClients.custom().setSSLContext(SSLTrustCA.trustLetsEncryptRootCA()).build());
    }

    public HttpClientImpl(CloseableHttpClient closableHttpClient) {
        this.closeableHttpClient = closableHttpClient;
        this.objectMapper = new ObjectMapper();
    }

    private CloseableHttpResponse getResponse(HttpRequestBase httpRequest) throws IndixApiException, IOException {
        CloseableHttpResponse response = this.closeableHttpClient.execute((HttpUriRequest)httpRequest);
        int status = response.getStatusLine().getStatusCode();
        if (200 != status) {
            String content = EntityUtils.toString((HttpEntity)response.getEntity());
            ErrorResponse error = (ErrorResponse)this.objectMapper.readValue(content, ErrorResponse.class);
            String message = error.getMessage();
            response.close();
            switch (status) {
                case 400: {
                    throw new BadRequestException(message);
                }
                case 500: {
                    throw new InternalServerException(message);
                }
                case 401: {
                    throw new UnauthorizedException(message);
                }
                case 402: {
                    throw new PaymentRequiredException(message);
                }
                case 429: {
                    throw new TooManyRequestsException(message);
                }
            }
            throw new IndixApiException(status, message);
        }
        return response;
    }

    @Override
    public String GET(URI uri) throws IOException, IndixApiException {
        HttpGet httpGet = new HttpGet(uri);
        try (CloseableHttpResponse response = this.getResponse((HttpRequestBase)httpGet);){
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
    }

    @Override
    public InputStream GETStream(URI uri) throws IOException, IndixApiException {
        HttpGet httpGet = new HttpGet(uri);
        CloseableHttpResponse response = this.getResponse((HttpRequestBase)httpGet);
        return response.getEntity().getContent();
    }

    @Override
    public String POST(URI uri, List<NameValuePair> params) throws IndixApiException, IOException {
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, Consts.UTF_8));
        try (CloseableHttpResponse response = this.getResponse((HttpRequestBase)httpPost);){
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
    }

    @Override
    public String POST(URI uri, List<NameValuePair> params, File file) throws IOException, IndixApiException {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        FileBody fileBody = new FileBody(file);
        builder.addPart("file", (ContentBody)fileBody);
        for (NameValuePair param : params) {
            builder.addTextBody(param.getName(), param.getValue());
        }
        HttpEntity multiPartEntiity = builder.build();
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setEntity(multiPartEntiity);
        try (CloseableHttpResponse response = this.getResponse((HttpRequestBase)httpPost);){
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
    }

    @Override
    public void close() throws IOException {
        this.closeableHttpClient.close();
    }
}

