package com.indix.models.product.productAtStore.offer;

import java.util.List;
import java.util.Map;

public class ProductOfferCatalog extends ProductOfferBase {
    private Map<String, List<String>> attributes;
    private List<String> tags;
    private Map<String, List<String>> facetAttributes;
    private String brandText;
    private String breadCrumbs;

    /**
     * The attributes element is a special case. It is an object that contains key to array of string values that
     * are automatically generated by our indexing system when gathering data about a product. Keys can cover a wide
     * range of attributes and vary between listings, depending on what information is provided by the store
     * @return The list of all the attributes for the product across all stores
     */
    public Map<String, List<String>> getAttributes() {
        return attributes;
    }

    /**
     * @return Array of	tags that are relevant to this product across all stores
     */
    public List<String> getTags() {
        return tags;
    }

    /**
     * The facetAttributes element is a special case. It is an object that contains key to array of string values that
     * are automatically generated by our indexing system when gathering data about a product. Keys can cover a wide
     * range of attributes and vary between listings, depending on what information is provided by the store
     * @return All the facetAttributes for the product across all stores
     */
    public Map<String, List<String>> getFacetAttributes() {
        return facetAttributes;
    }

    /**
     * @return Brand text of the product
     */
    public String getBrandText() {
        return brandText;
    }

    /**
     * @return Breadcrumbs of the product
     */
    public String getBreadCrumbs() {
        return breadCrumbs;
    }
}
