/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.vw.wrapper.learner;

import com.google.common.base.Splitter;
import com.indeed.vw.wrapper.jni.NativeUtils;
import com.indeed.vw.wrapper.learner.VWActionProbsLearner;
import com.indeed.vw.wrapper.learner.VWActionScoresLearner;
import com.indeed.vw.wrapper.learner.VWLearner;
import com.indeed.vw.wrapper.learner.VWMulticlassLearner;
import com.indeed.vw.wrapper.learner.VWMultilabelsLearner;
import com.indeed.vw.wrapper.learner.VWProbLearner;
import com.indeed.vw.wrapper.learner.VWScalarLearner;
import com.indeed.vw.wrapper.learner.VWScalarsLearner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class VWLearners {
    private VWLearners() {
    }

    public static <T extends VWLearner> T create(List<String> command) {
        long nativePointer = VWLearners.initialize(command.toArray(new String[0]));
        VWReturnType returnType = VWLearners.getReturnType(nativePointer);
        switch (returnType) {
            case ActionProbs: {
                return (T)new VWActionProbsLearner(nativePointer);
            }
            case ActionScores: {
                return (T)new VWActionScoresLearner(nativePointer);
            }
            case Multiclass: {
                return (T)new VWMulticlassLearner(nativePointer);
            }
            case Multilabels: {
                return (T)new VWMultilabelsLearner(nativePointer);
            }
            case Prob: {
                return (T)new VWProbLearner(nativePointer);
            }
            case Scalar: {
                return (T)new VWScalarLearner(nativePointer);
            }
            case Scalars: {
                return (T)new VWScalarsLearner(nativePointer);
            }
        }
        VWLearners.closeInstance(nativePointer);
        throw new IllegalArgumentException("Unknown VW return type using command: " + command);
    }

    public static <T extends VWLearner> T create(String command) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("vw");
        args.addAll(Splitter.on((char)' ').splitToList((CharSequence)command));
        return VWLearners.create(args);
    }

    private static native long initialize(String[] var0);

    private static native VWReturnType getReturnType(long var0);

    static native void closeInstance(long var0);

    static native void performRemainingPasses(long var0);

    static native void saveModel(long var0, String var2);

    static {
        try {
            NativeUtils.loadOSDependentLibrary("/lib/vw_jni", ".lib");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static enum VWReturnType {
        Unknown,
        ActionProbs,
        ActionScores,
        Multiclass,
        Multilabels,
        Prob,
        Scalar,
        Scalars;

    }
}

