/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.vw.wrapper.api;

import com.google.common.base.Joiner;
import com.indeed.vw.wrapper.api.parameters.Link;
import com.indeed.vw.wrapper.api.parameters.Loss;
import com.indeed.vw.wrapper.api.parameters.SGDVowpalWabbitBuilder;
import com.indeed.vw.wrapper.learner.VWFloatArrayLearner;
import com.indeed.vw.wrapper.learner.VWFloatLearner;
import com.indeed.vw.wrapper.learner.VWIntArrayLearner;
import com.indeed.vw.wrapper.learner.VWIntLearner;
import com.indeed.vw.wrapper.learner.VWLearners;
import java.nio.file.Path;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class VowpalWabbit {
    public static final String ANY_NAMESPACE = ":";
    private static final Logger logger = Logger.getLogger(VowpalWabbit.class);

    private VowpalWabbit() {
    }

    public static SGDVowpalWabbitBuilder builder() {
        return new Builder();
    }

    public static Builder advancedBuilder() {
        return new Builder();
    }

    public static class Builder
    implements SGDVowpalWabbitBuilder {
        private final StringBuilder argumentsStringBuilder = new StringBuilder();
        private boolean verbose = false;

        private Builder() {
        }

        @Override
        public Builder verbose() {
            this.verbose = true;
            return this;
        }

        @Override
        public Builder randomSeed(int seed) {
            this.argumentsStringBuilder.append("--random_seed " + seed + " ");
            return this;
        }

        public Builder ringSize(int ringSize) {
            this.argumentsStringBuilder.append("--ring_size " + ringSize + " ");
            return this;
        }

        @Override
        public Builder learningRate(double learningRate) {
            this.argumentsStringBuilder.append("--learning_rate " + learningRate + " ");
            return this;
        }

        public Builder powerT(double powerT) {
            this.argumentsStringBuilder.append("--power_t " + powerT + " ");
            return this;
        }

        public Builder decayLearningRate(double decay) {
            this.argumentsStringBuilder.append("--decay_learning_rate " + decay + " ");
            return this;
        }

        public Builder initialT(double initialT) {
            this.argumentsStringBuilder.append("--initial_t " + initialT + " ");
            return this;
        }

        @Override
        public Builder featureMask(Path featureMask) {
            this.argumentsStringBuilder.append("--feature_mask " + featureMask + " ");
            return this;
        }

        @Override
        public Builder initialRegressor(Path initialRegressor) {
            this.argumentsStringBuilder.append("--initial_regressor " + initialRegressor + " ");
            return this;
        }

        public Builder initialWeight(double weight) {
            this.argumentsStringBuilder.append("--initial_weight " + weight + " ");
            return this;
        }

        public Builder randomWeights(double arg) {
            this.argumentsStringBuilder.append("--random_weights " + arg + " ");
            return this;
        }

        public Builder inputFeatureRegularizer(Path regularizationPath) {
            this.argumentsStringBuilder.append("--input_feature_regularizer " + regularizationPath + " ");
            return this;
        }

        public Builder hash(Hash hash) {
            this.argumentsStringBuilder.append("--hash " + (Object)((Object)hash) + " ");
            return this;
        }

        public Builder ignore(String namespace) {
            this.argumentsStringBuilder.append("--ignore " + namespace.charAt(0) + " ");
            return this;
        }

        public Builder keep(String namespace) {
            this.argumentsStringBuilder.append("--keep " + namespace.charAt(0) + " ");
            return this;
        }

        public Builder redefine(String newNamespace, String ... namespaces) {
            StringBuilder oldNamespaces = new StringBuilder();
            for (String namespace : namespaces) {
                oldNamespaces.append(namespace.charAt(0));
            }
            this.argumentsStringBuilder.append("--redefine " + newNamespace + ":=" + oldNamespaces + " ");
            return this;
        }

        @Override
        public Builder bitPrecision(int bitsNum) {
            this.argumentsStringBuilder.append("--bit_precision " + bitsNum + " ");
            return this;
        }

        @Override
        public Builder noconstant() {
            this.argumentsStringBuilder.append("--noconstant ");
            return this;
        }

        @Override
        public Builder constant(double initialValue) {
            this.argumentsStringBuilder.append("--constant " + initialValue + " ");
            return this;
        }

        @Override
        public Builder ngram(String namespace, int n) {
            if (namespace.equals(VowpalWabbit.ANY_NAMESPACE)) {
                this.argumentsStringBuilder.append("--ngram " + n + " ");
                return this;
            }
            this.argumentsStringBuilder.append("--ngram " + namespace.charAt(0) + "" + n + " ");
            return this;
        }

        @Override
        public Builder skips(String namespace, int n) {
            if (namespace.equals(VowpalWabbit.ANY_NAMESPACE)) {
                this.argumentsStringBuilder.append("--skips " + n + " ");
                return this;
            }
            this.argumentsStringBuilder.append("--skips " + namespace.charAt(0) + "" + n + " ");
            return this;
        }

        public Builder featureLimit(int n) {
            this.argumentsStringBuilder.append("--feature_limit " + n + " ");
            return this;
        }

        public Builder affix(String arg) {
            this.argumentsStringBuilder.append("--affix " + arg + " ");
            return this;
        }

        public Builder spelling(String namespace) {
            this.argumentsStringBuilder.append("--spelling " + namespace.charAt(0) + " ");
            return this;
        }

        public Builder dictionary(Path file) {
            this.argumentsStringBuilder.append("--dictionary " + file + " ");
            return this;
        }

        public Builder dictionaryPath(Path dir) {
            this.argumentsStringBuilder.append("--dictionary_path " + dir + " ");
            return this;
        }

        public Builder interactions(String ... namespaces) {
            StringBuilder namespacesChars = new StringBuilder();
            for (String namespace : namespaces) {
                namespacesChars.append(namespace.charAt(0));
            }
            this.argumentsStringBuilder.append("--interactions " + namespacesChars + " ");
            return this;
        }

        public Builder permutations() {
            this.argumentsStringBuilder.append("--permutations ");
            return this;
        }

        public Builder leaveDuplicateInteractions() {
            this.argumentsStringBuilder.append("--leave_duplicate_interactions ");
            return this;
        }

        @Override
        public Builder quadratic(String firstNameSpace, String secondNamespace) {
            this.argumentsStringBuilder.append("--quadratic " + firstNameSpace.charAt(0) + "" + secondNamespace.charAt(0) + " ");
            return this;
        }

        @Override
        public Builder cubic(String firstNameSpace, String secondNamespace, String thirdNamespace) {
            this.argumentsStringBuilder.append("--cubic " + firstNameSpace.charAt(0) + "" + secondNamespace.charAt(0) + "" + thirdNamespace.charAt(0) + " ");
            return this;
        }

        @Override
        public Builder testonly() {
            this.argumentsStringBuilder.append("--testonly ");
            return this;
        }

        public Builder holdoutPeriod(int holdout) {
            this.argumentsStringBuilder.append("--holdout_period " + holdout + " ");
            return this;
        }

        public Builder holdoutAfter(int n) {
            this.argumentsStringBuilder.append("--holdout_after " + n + " ");
            return this;
        }

        public Builder earlyTerminate(int passes) {
            this.argumentsStringBuilder.append("--early_terminate " + passes + " ");
            return this;
        }

        public Builder passes(int passes) {
            this.argumentsStringBuilder.append("--passes " + passes + " ");
            return this.cache();
        }

        public Builder initialPassLength(int examples) {
            this.argumentsStringBuilder.append("--initial_pass_length " + examples + " ");
            return this;
        }

        public Builder examples(int examples) {
            this.argumentsStringBuilder.append("--examples " + examples + " ");
            return this;
        }

        @Override
        public Builder minPrediction(double min) {
            this.argumentsStringBuilder.append("--min_prediction " + min + " ");
            return this;
        }

        @Override
        public Builder maxPrediction(double max) {
            this.argumentsStringBuilder.append("--max_prediction " + max + " ");
            return this;
        }

        public Builder sortFeatures() {
            this.argumentsStringBuilder.append("--sort_features ");
            return this;
        }

        @Override
        public Builder lossFunction(Loss loss) {
            this.argumentsStringBuilder.append("--loss_function " + (Object)((Object)loss) + " ");
            return this;
        }

        @Override
        public Builder quantileTau(double tau) {
            this.argumentsStringBuilder.append("--quantile_tau " + tau + " ");
            return this;
        }

        @Override
        public Builder l1(double l1) {
            this.argumentsStringBuilder.append("--l1 " + l1 + " ");
            return this;
        }

        @Override
        public Builder l2(double l2) {
            this.argumentsStringBuilder.append("--l2 " + l2 + " ");
            return this;
        }

        public Builder namedLabels(String ... labels) {
            this.argumentsStringBuilder.append("--named_labels " + Joiner.on((String)",").join(Arrays.asList(labels)) + " ");
            return this;
        }

        @Override
        public Builder finalRegressor(Path regressor) {
            this.argumentsStringBuilder.append("--final_regressor " + regressor + " ");
            return this;
        }

        @Override
        public Builder readableModel(Path model) {
            this.argumentsStringBuilder.append("--readable_model " + model + " ");
            return this;
        }

        public Builder saveResume() {
            this.argumentsStringBuilder.append("--save_resume ");
            return this;
        }

        public Builder savePerPass() {
            this.argumentsStringBuilder.append("--save_per_pass ");
            return this;
        }

        public Builder outputFeatureRegularizerBinary(Path regularizationFile) {
            this.argumentsStringBuilder.append("--output_feature_regularizer_binary " + regularizationFile + " ");
            return this;
        }

        public Builder outputFeatureRegularizerText(Path regularizationFile) {
            this.argumentsStringBuilder.append("--output_feature_regularizer_text " + regularizationFile + " ");
            return this;
        }

        public Builder id(String id) {
            this.argumentsStringBuilder.append("--id " + id + " ");
            return this;
        }

        public Builder auditRegressor(Path regressor) {
            this.argumentsStringBuilder.append("--audit_regressor " + regressor + " ");
            return this;
        }

        public Builder bootstrap(int k) {
            this.argumentsStringBuilder.append("--bootstrap " + k + " ");
            return this;
        }

        public Builder search(int maxActionID) {
            this.argumentsStringBuilder.append("--search " + maxActionID + " ");
            return this;
        }

        public Builder replayC(String arg) {
            this.argumentsStringBuilder.append("--replay_c " + arg + " ");
            return this;
        }

        public Builder cbify(int k) {
            this.argumentsStringBuilder.append("--cbify " + k + " ");
            return this;
        }

        public Builder cbExploreAdf() {
            this.argumentsStringBuilder.append("--cb_explore_adf ");
            return this;
        }

        public Builder cbExplore(int k) {
            this.argumentsStringBuilder.append("--cb_explore " + k + " ");
            return this;
        }

        public Builder multiworldTest(String arg) {
            this.argumentsStringBuilder.append("--multiworld_test " + arg + " ");
            return this;
        }

        public Builder cbAdf() {
            this.argumentsStringBuilder.append("--cb_adf ");
            return this;
        }

        public Builder cb(int k) {
            this.argumentsStringBuilder.append("--cb " + k + " ");
            return this;
        }

        public Builder csoaaLdf(LDF ldf) {
            this.argumentsStringBuilder.append("--csoaa_ldf " + (Object)((Object)ldf) + " ");
            return this;
        }

        public Builder wapLdf(LDF ldf) {
            this.argumentsStringBuilder.append("--wap_ldf " + (Object)((Object)ldf) + " ");
            return this;
        }

        public Builder interact(String arg) {
            this.argumentsStringBuilder.append("--interact " + arg + " ");
            return this;
        }

        public Builder csoaa(int k) {
            this.argumentsStringBuilder.append("--csoaa " + k + " ");
            return this;
        }

        public Builder multilabelOaa(int k) {
            this.argumentsStringBuilder.append("--multilabel_oaa " + k + " ");
            return this;
        }

        public Builder recallTree(int k) {
            this.argumentsStringBuilder.append("--recall_tree " + k + " ");
            return this;
        }

        public Builder logMulti(int k) {
            this.argumentsStringBuilder.append("--log_multi " + k + " ");
            return this;
        }

        public Builder ect(int k) {
            this.argumentsStringBuilder.append("--ect " + k + " ");
            return this;
        }

        public Builder boosting(int n) {
            this.argumentsStringBuilder.append("--boosting " + n + " ");
            return this;
        }

        public Builder oaa(int k) {
            this.argumentsStringBuilder.append("--oaa " + k + " ");
            return this;
        }

        public Builder top(int k) {
            this.argumentsStringBuilder.append("--top " + k + " ");
            return this;
        }

        public Builder replayM(String arg) {
            this.argumentsStringBuilder.append("--replay_m " + arg + " ");
            return this;
        }

        public Builder binary() {
            this.argumentsStringBuilder.append("--binary ");
            return this;
        }

        @Override
        public Builder link(Link link) {
            this.argumentsStringBuilder.append("--link " + (Object)((Object)link) + " ");
            return this;
        }

        public Builder stagePoly() {
            this.argumentsStringBuilder.append("--stage_poly ");
            return this;
        }

        @Override
        public Builder lrqfa(String firstNamespace, String secondNamespace, int k) {
            this.argumentsStringBuilder.append("--lrqfa " + firstNamespace.charAt(0) + "" + secondNamespace.charAt(0) + "" + k + " ");
            return this;
        }

        public Builder lrq(String firstNamespace, String secondNamespace, int k) {
            this.argumentsStringBuilder.append("--lrq " + firstNamespace.charAt(0) + "" + secondNamespace.charAt(0) + "" + k + " ");
            return this;
        }

        public Builder lrqdropout() {
            this.argumentsStringBuilder.append("--lrqdropout ");
            return this;
        }

        public Builder autolink(int d) {
            this.argumentsStringBuilder.append("--autolink " + d + " ");
            return this;
        }

        public Builder newMf(int rank) {
            this.argumentsStringBuilder.append("--new_mf " + rank + " ");
            return this;
        }

        public Builder nn(int units) {
            this.argumentsStringBuilder.append("--nn " + units + " ");
            return this;
        }

        public Builder confidenceAfterTraining() {
            this.argumentsStringBuilder.append("--confidence_after_training ");
            return this;
        }

        public Builder confidence() {
            this.argumentsStringBuilder.append("--confidence ");
            return this;
        }

        public Builder activeCover() {
            this.argumentsStringBuilder.append("--active_cover ");
            return this;
        }

        public Builder active() {
            this.argumentsStringBuilder.append("--active ");
            return this;
        }

        public Builder replayB(String arg) {
            this.argumentsStringBuilder.append("--replay_b " + arg + " ");
            return this;
        }

        public Builder ojaNewton() {
            this.argumentsStringBuilder.append("--OjaNewton ");
            return this;
        }

        public Builder bfgs() {
            this.argumentsStringBuilder.append("--bfgs ");
            return this;
        }

        public Builder conjugateGradient() {
            this.argumentsStringBuilder.append("--conjugate_gradient ");
            return this;
        }

        public Builder lda(int topics) {
            this.argumentsStringBuilder.append("--lda " + topics + " ");
            return this;
        }

        public Builder noop() {
            this.argumentsStringBuilder.append("--noop ");
            return this;
        }

        public Builder rank(int rank) {
            this.argumentsStringBuilder.append("--rank " + rank + " ");
            return this;
        }

        public Builder svrg() {
            this.argumentsStringBuilder.append("--svrg ");
            return this;
        }

        @Override
        public Builder ftrl() {
            this.argumentsStringBuilder.append("--ftrl ");
            return this;
        }

        public Builder pistol() {
            this.argumentsStringBuilder.append("--pistol ");
            return this;
        }

        public Builder ksvm() {
            this.argumentsStringBuilder.append("--ksvm ");
            return this;
        }

        @Override
        public Builder sgd() {
            this.argumentsStringBuilder.append("--sgd ");
            return this;
        }

        @Override
        public Builder adaptive() {
            this.argumentsStringBuilder.append("--adaptive ");
            return this;
        }

        @Override
        public Builder invariant() {
            this.argumentsStringBuilder.append("--invariant ");
            return this;
        }

        @Override
        public Builder normalized() {
            this.argumentsStringBuilder.append("--normalized ");
            return this;
        }

        public Builder sparseL2(double l2) {
            this.argumentsStringBuilder.append("--sparse_l2 " + l2 + " ");
            return this;
        }

        public Builder cache() {
            this.argumentsStringBuilder.append("--cache ");
            return this;
        }

        public Builder cacheFile(Path cacheFile) {
            this.argumentsStringBuilder.append("--cache_file " + cacheFile + " ");
            return this;
        }

        public Builder killCache() {
            this.argumentsStringBuilder.append("--kill_cache ");
            return this;
        }

        public Builder compressed() {
            this.argumentsStringBuilder.append("--compressed ");
            return this;
        }

        public Builder parameter(String argumentLine) {
            this.argumentsStringBuilder.append(argumentLine).append(' ');
            return this;
        }

        public String getCommand() {
            return this.argumentsStringBuilder.toString() + (this.verbose ? "" : " --quiet");
        }

        @Override
        public VWFloatLearner buildFloatLearner() {
            logger.info((Object)("Vowpal wabbit command: " + this.getCommand()));
            return (VWFloatLearner)VWLearners.create(this.getCommand());
        }

        public VWIntLearner buildIntLearner() {
            logger.info((Object)("Vowpal wabbit command: " + this.getCommand()));
            return (VWIntLearner)VWLearners.create(this.getCommand());
        }

        public VWFloatArrayLearner buildFloatArrayLearner() {
            logger.info((Object)("Vowpal wabbit command: " + this.getCommand()));
            return (VWFloatArrayLearner)VWLearners.create(this.getCommand());
        }

        public VWIntArrayLearner buildIntArrayLearner() {
            logger.info((Object)("Vowpal wabbit command: " + this.getCommand()));
            return (VWIntArrayLearner)VWLearners.create(this.getCommand());
        }
    }

    public static enum LDF {
        singleline,
        multiline;

    }

    public static enum Hash {
        strings,
        all;

    }
}

