/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.serialization;

import com.indeed.util.serialization.Serializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.log4j.Logger;

public final class LengthVIntSerializer
implements Serializer<Integer> {
    private static final Logger log = Logger.getLogger(LengthVIntSerializer.class);

    @Override
    public void write(Integer i, DataOutput out) throws IOException {
        if (i < 255) {
            out.writeByte(i);
        } else {
            out.writeByte(255);
            out.writeInt(i);
        }
    }

    @Override
    public Integer read(DataInput in) throws IOException {
        int firstByte = in.readByte() & 0xFF;
        if (firstByte != 255) {
            return firstByte;
        }
        return in.readInt();
    }
}

