/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.mmap;

import com.indeed.util.mmap.Memory;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MemoryInputStream
extends InputStream {
    private static final Logger log = LoggerFactory.getLogger(MemoryInputStream.class);
    private final Memory memory;
    private long position = 0L;

    public MemoryInputStream(Memory memory) {
        this.memory = memory;
    }

    @Override
    public int read() throws IOException {
        if (this.position >= this.length()) {
            return -1;
        }
        return this.memory.getByte(this.position++) & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = (int)Math.min((long)len, this.length() - this.position);
        if (read == 0) {
            return -1;
        }
        this.memory.getBytes(this.position, b, off, read);
        this.position += (long)read;
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        this.position += n;
        return n;
    }

    public void seek(long position) {
        if (position < 0L || position > this.length()) {
            throw new IndexOutOfBoundsException(String.valueOf(position));
        }
        this.position = position;
    }

    public long getPos() {
        return this.position;
    }

    public long length() {
        return this.memory.length();
    }
}

