/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.mmap;

import com.indeed.util.mmap.Memory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FloatArray {
    private static final Logger log = LoggerFactory.getLogger(FloatArray.class);
    private static final long TYPE_SIZE = 4L;
    private final Memory buffer;
    private final long length;

    public FloatArray(Memory buffer, long address, long length) {
        if (address < 0L) {
            throw new IndexOutOfBoundsException("address must be >= 0");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (address + length * 4L > buffer.length()) {
            throw new IndexOutOfBoundsException(String.format("address+length*%d must be <= buffer.length()", 4L));
        }
        this.buffer = buffer.slice(address, length * 4L);
        this.length = length;
    }

    public float get(long index) {
        return this.buffer.getFloat(index * 4L);
    }

    public void get(long index, float[] floats, int start, int length) {
        for (int i = 0; i < length; ++i) {
            floats[start + i] = this.buffer.getFloat((index + (long)i) * 4L);
        }
    }

    public void get(long index, float[] floats) {
        this.get(index, floats, 0, floats.length);
    }

    public void get(long index, FloatArray floats, long start, long length) {
        floats.set(start, this, index, length);
    }

    public void get(long index, FloatArray floats) {
        this.get(index, floats, 0L, floats.length);
    }

    public void set(long index, float value) {
        this.buffer.putFloat(index * 4L, value);
    }

    public void set(long index, float[] floats, int start, int length) {
        for (int i = 0; i < length; ++i) {
            this.buffer.putFloat((index + (long)i) * 4L, floats[start + i]);
        }
    }

    public void set(long index, float[] floats) {
        this.set(index, floats, 0, floats.length);
    }

    public void set(long index, FloatArray floats, long start, long length) {
        floats.buffer.getBytes(index * 4L, this.buffer, start * 4L, length * 4L);
    }

    public void set(long index, FloatArray floats) {
        this.set(index, floats, 0L, floats.length);
    }

    public long length() {
        return this.length;
    }

    public FloatArray slice(long start, long length) {
        return new FloatArray(this.buffer, start * 4L, length);
    }
}

