/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.core;

import com.indeed.util.core.DataLoadTimer;
import com.indeed.util.core.HasDataLoadingVariables;
import com.indeed.util.varexport.VarExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataLoadingRunnable
extends DataLoadTimer
implements HasDataLoadingVariables,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(DataLoadingRunnable.class);
    private String dataVersion;
    private ReloadState reloadState;

    public DataLoadingRunnable(String namespace) {
        VarExporter.forNamespace((String)namespace).includeInGlobal().export((Object)this, "");
    }

    public void setDataVersion(String version) {
        this.dataVersion = version;
    }

    @Override
    public String getDataVersion() {
        return this.dataVersion;
    }

    public ReloadState getReloadState() {
        return this.reloadState;
    }

    public abstract boolean load();

    protected boolean finishLoadWithReloadState(ReloadState state, String newDataVersion) {
        if (state == ReloadState.RELOADED) {
            this.loadComplete();
            this.setDataVersion(newDataVersion);
            return true;
        }
        if (state == ReloadState.NO_CHANGE) {
            this.loadNotChanged();
            return false;
        }
        this.loadFailed();
        return false;
    }

    @Override
    public void loadComplete() {
        super.loadComplete();
        this.reloadState = ReloadState.RELOADED;
    }

    @Override
    public void loadFailed() {
        super.loadFailed();
        this.reloadState = ReloadState.FAILED;
    }

    public void loadNotChanged() {
        this.reloadState = ReloadState.NO_CHANGE;
        if (this.wasLastLoadErroring()) {
            log.info("Last load was in error, so updating last success time anyway");
            this.updateLastSuccessLoadTime();
        }
    }

    @Override
    public final void run() {
        try {
            this.updateLastLoadCheck();
            if (this.load()) {
                this.loadComplete();
            }
        }
        catch (RuntimeException e) {
            this.loadFailed();
            log.error("Ignoring RuntimeException", (Throwable)e);
        }
        catch (Error e) {
            this.loadFailed();
            log.error("Ignoring Error", (Throwable)e);
        }
    }

    public static enum ReloadState {
        RELOADED,
        NO_CHANGE,
        FAILED;

    }
}

