/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.core;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class NetUtils {
    private static final Logger log = Logger.getLogger(NetUtils.class);
    private static volatile Optional<String> OPT_HOSTNAME = Optional.absent();
    private static final Pattern IPV4_ADDRESS = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");

    @Nonnull
    public static String determineHostName() throws UnknownHostException {
        if (!OPT_HOSTNAME.isPresent()) {
            String hostName = InetAddress.getLocalHost().getHostName();
            if (Strings.isNullOrEmpty((String)hostName)) {
                throw new UnknownHostException("Unable to lookup localhost, got back empty hostname");
            }
            if (Strings.nullToEmpty((String)hostName).equals("0.0.0.0")) {
                throw new UnknownHostException("Unable to resolve correct hostname saw bad host");
            }
            OPT_HOSTNAME = Optional.of((Object)hostName);
            return (String)OPT_HOSTNAME.get();
        }
        return (String)OPT_HOSTNAME.get();
    }

    @Nonnull
    public static String determineHostName(@Nonnull String defaultValue) {
        Preconditions.checkNotNull((Object)defaultValue, (Object)"Unable to use default value of null for hostname");
        if (!OPT_HOSTNAME.isPresent()) {
            try {
                return NetUtils.determineHostName();
            }
            catch (UnknownHostException e) {
                log.error((Object)("Unable to find hostname " + e.getMessage()), (Throwable)e);
            }
        }
        return (String)OPT_HOSTNAME.or((Object)defaultValue);
    }

    @Nullable
    public static String determineIpAddress() throws SocketException {
        SocketException caughtException = null;
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            try {
                NetworkInterface nextInterface = networkInterfaces.nextElement();
                if (nextInterface.isLoopback() || nextInterface.isVirtual() || nextInterface.isPointToPoint()) continue;
                Enumeration<InetAddress> addresses = nextInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress inetAddress = addresses.nextElement();
                    byte[] address = inetAddress.getAddress();
                    if (address.length != 4 || address[0] == 127 && address[1] == 0) continue;
                    return inetAddress.getHostAddress();
                }
            }
            catch (SocketException ex) {
                caughtException = ex;
            }
        }
        if (caughtException != null) {
            throw caughtException;
        }
        return null;
    }

    public static byte[] getRawAddress(String ipv4Address) {
        Matcher m = IPV4_ADDRESS.matcher(ipv4Address);
        if (!m.find()) {
            return null;
        }
        byte[] addr = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int intVal = Integer.parseInt(m.group(i + 1)) & 0xFF;
            addr[i] = (byte)intVal;
        }
        return addr;
    }
}

