/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.core;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Nonnull;

public class TreeTimer {
    Stack<Long> timeStack = new Stack();
    Stack<Node> nodeStack = new Stack();
    Node root = new Node();

    public void push(String s) {
        Node node = this.nodeStack.isEmpty() ? this.root : this.nodeStack.peek();
        this.nodeStack.push(node.getChild(s));
        this.timeStack.push(System.currentTimeMillis());
    }

    public int pop() {
        if (!this.nodeStack.isEmpty()) {
            Node node = this.nodeStack.pop();
            long start = this.timeStack.pop();
            long duration = System.currentTimeMillis() - start;
            node.time += duration;
            return (int)duration;
        }
        return -1;
    }

    private static long findMaxTime(Node n) {
        long max = Long.MIN_VALUE;
        for (Map.Entry<String, Node> entry : n.children.entrySet()) {
            max = Math.max(max, entry.getValue().time);
        }
        return max;
    }

    private static void printNode(int indent, Node n, StringBuilder ret) {
        if (n.children == null) {
            return;
        }
        long max = TreeTimer.findMaxTime(n);
        int width = String.valueOf(max).length();
        for (Map.Entry<String, Node> entry : n.children.entrySet()) {
            ret.append(TreeTimer.leftpad(String.valueOf(entry.getValue().time), width + indent));
            ret.append("ms ").append(entry.getKey()).append("\n");
            TreeTimer.printNode(indent + width + 3, entry.getValue(), ret);
        }
    }

    @Nonnull
    private static String leftpad(@Nonnull String s, int n) {
        return TreeTimer.leftpad(s, n, ' ');
    }

    @Nonnull
    private static String leftpad(@Nonnull String s, int n, char padChar) {
        int diff = n - s.length();
        if (diff <= 0) {
            return s;
        }
        StringBuilder buf = new StringBuilder(n);
        for (int i = 0; i < diff; ++i) {
            buf.append(padChar);
        }
        buf.append(s);
        return buf.toString();
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        TreeTimer.printNode(2, this.root, ret);
        return ret.toString();
    }

    private static class Node {
        long time = 0L;
        Map<String, Node> children = null;

        private Node() {
        }

        Node getChild(String s) {
            Node child;
            if (this.children == null) {
                this.children = new LinkedHashMap<String, Node>();
            }
            if ((child = this.children.get(s)) == null) {
                child = new Node();
                this.children.put(s, child);
            }
            return child;
        }
    }
}

