/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.util.core.datastruct;

import java.lang.reflect.Array;
import org.apache.log4j.Logger;

public abstract class IteratorMultiHeap<T> {
    private static final Logger log = Logger.getLogger(IteratorMultiHeap.class);
    private final T[] elements;
    private int[] candidates;
    private int[] nextCandidates;
    private int size;
    private final int[] minIndexes;
    private final T[] min;
    private int minLength;

    protected IteratorMultiHeap(int capacity, Class<T> tClass) {
        this.elements = (Object[])Array.newInstance(tClass, capacity);
        this.size = 0;
        this.candidates = new int[(capacity + 1) / 2];
        this.nextCandidates = new int[this.candidates.length];
        this.minIndexes = new int[capacity];
        this.min = (Object[])Array.newInstance(tClass, capacity);
        this.minLength = 0;
    }

    protected abstract boolean next(T var1);

    protected abstract int compare(T var1, T var2);

    public final void clear() {
        this.minLength = 0;
        this.size = 0;
    }

    public final void add(T t) {
        if (this.size == this.elements.length) {
            throw new IllegalStateException("heap is full");
        }
        if (this.minLength != this.size) {
            throw new IllegalStateException("must call clear before adding elements");
        }
        this.elements[this.size] = t;
        this.minIndexes[this.size] = this.size;
        ++this.size;
        ++this.minLength;
    }

    public final T[] getMin() {
        return this.min;
    }

    public final int getMinLength() {
        return this.minLength;
    }

    public final boolean next() {
        Object tmp;
        if (this.size == 0) {
            return false;
        }
        for (int i = this.minLength - 1; i >= 0; --i) {
            T element = this.elements[this.minIndexes[i]];
            if (!this.next(element)) {
                --this.size;
                if (this.size == 0) {
                    return false;
                }
                tmp = this.elements[this.minIndexes[i]];
                this.elements[this.minIndexes[i]] = this.elements[this.size];
                this.elements[this.size] = tmp;
            }
            this.downHeap(this.minIndexes[i]);
        }
        int numCandidates = 0;
        if (this.size > 1) {
            this.candidates[0] = 1;
            numCandidates = 1;
        }
        if (this.size > 2) {
            this.candidates[1] = 2;
            numCandidates = 2;
        }
        this.minIndexes[0] = 0;
        this.min[0] = this.elements[0];
        this.minLength = 1;
        while (numCandidates > 0) {
            int nextNumCandidates = 0;
            for (int i = 0; i < numCandidates; ++i) {
                int right;
                int index = this.candidates[i];
                if (this.compare(this.elements[index], this.elements[0]) != 0) continue;
                this.minIndexes[this.minLength] = index;
                this.min[this.minLength] = this.elements[index];
                ++this.minLength;
                int left = index * 2 + 1;
                if (left < this.size) {
                    this.nextCandidates[nextNumCandidates++] = left;
                }
                if ((right = left + 1) >= this.size) continue;
                this.nextCandidates[nextNumCandidates++] = right;
            }
            numCandidates = nextNumCandidates;
            tmp = this.candidates;
            this.candidates = this.nextCandidates;
            this.nextCandidates = (int[])tmp;
        }
        return true;
    }

    private void downHeap(int index) {
        while (true) {
            int lowerIndex;
            int leftIndex = index * 2 + 1;
            int rightIndex = leftIndex + 1;
            if (leftIndex >= this.size) break;
            int n = rightIndex >= this.size ? leftIndex : (lowerIndex = this.compare(this.elements[leftIndex], this.elements[rightIndex]) <= 0 ? leftIndex : rightIndex);
            if (this.compare(this.elements[lowerIndex], this.elements[index]) >= 0) break;
            T tmp = this.elements[index];
            this.elements[index] = this.elements[lowerIndex];
            this.elements[lowerIndex] = tmp;
            index = lowerIndex;
        }
    }
}

