/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.pipet.deploy;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePropertySource;
import org.springframework.web.context.ConfigurableWebApplicationContext;

public class PropertiesInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final String contextPropertiesParameterName = "propertyPlaceholderResourceLocation";

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment springEnv = applicationContext.getEnvironment();
        MutablePropertySources propSources = springEnv.getPropertySources();
        for (String location : this.getPropertyLocations(applicationContext)) {
            this.tryAddPropertySource(applicationContext, propSources, location);
        }
        this.addPropertySources(applicationContext, propSources);
    }

    protected List<String> getPropertyLocations(ConfigurableApplicationContext applicationContext) {
        ArrayList propertyLocations = Lists.newArrayList();
        propertyLocations.addAll(this.getBasePropertyLocations(applicationContext));
        propertyLocations.addAll(this.getTomcatConfPropertyLocations(applicationContext));
        propertyLocations.addAll(this.getTomcatContextPropertyLocations(applicationContext));
        return propertyLocations;
    }

    protected boolean tryAddPropertySource(ConfigurableApplicationContext applicationContext, MutablePropertySources propSources, String filePath) {
        if (filePath == null) {
            return false;
        }
        Resource propertiesResource = applicationContext.getResource(filePath);
        if (!propertiesResource.exists()) {
            return false;
        }
        try {
            ResourcePropertySource propertySource = new ResourcePropertySource(propertiesResource);
            propSources.addFirst((PropertySource)propertySource);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    protected void addPropertySources(ConfigurableApplicationContext applicationContext, MutablePropertySources propSources) {
    }

    protected String getWebappName() {
        return "pipet";
    }

    protected String getConfigFileName(String suffix) {
        String fileName = this.getWebappName();
        if (!Strings.isNullOrEmpty((String)suffix)) {
            fileName = fileName + "-" + suffix;
        }
        fileName = fileName + ".properties";
        return fileName;
    }

    protected List<String> getBasePropertyLocations(ConfigurableApplicationContext applicationContext) {
        String configFile = this.getRepoConfigLocation() + this.getConfigFileName("base");
        return Lists.newArrayList((Object[])new String[]{configFile});
    }

    protected String getRepoConfigLocation() {
        return "WEB-INF/config/";
    }

    protected List<String> getTomcatConfPropertyLocations(ConfigurableApplicationContext applicationContext) {
        String tomcatPropFile = this.getTomcatConfDir() + this.getConfigFileName(null);
        return Lists.newArrayList((Object[])new String[]{tomcatPropFile});
    }

    protected String getTomcatConfDir() {
        return "file:" + System.getProperty("catalina.base") + "/conf/";
    }

    protected List<String> getTomcatContextPropertyLocations(ConfigurableApplicationContext applicationContext) {
        if (!(applicationContext instanceof ConfigurableWebApplicationContext)) {
            return Collections.emptyList();
        }
        ConfigurableWebApplicationContext webApplicationContext = (ConfigurableWebApplicationContext)applicationContext;
        ArrayList locations = Lists.newArrayList();
        String tomcatContextPropertiesFile = webApplicationContext.getServletContext().getInitParameter(contextPropertiesParameterName);
        locations.add("file:" + tomcatContextPropertiesFile);
        return locations;
    }
}

