/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.pipet.deploy.useragent;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.indeed.proctor.pipet.deploy.useragent.UserAgent;
import eu.bitwalker.useragentutils.OperatingSystem;
import eu.bitwalker.useragentutils.Version;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class VersionedOS {
    @Nonnull
    private final OperatingSystem os;
    @Nonnull
    private final String version;
    private final int majorVersion;
    private final int minorVersion;
    private static final Pattern ANDROID_PATTERN = Pattern.compile("Android (\\d+(?:\\.\\d+)+)");
    public static final Version UNKNOWN_VERSION = new Version(null, null, null);

    private VersionedOS(@Nonnull OperatingSystem os, @Nonnull String version, int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.os = null == os.getGroup() ? os : os.getGroup();
        this.version = version;
    }

    @Nonnull
    public String getFamily() {
        return this.os.name().toLowerCase();
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Nonnull
    public String getVersion() {
        return this.version;
    }

    @Nonnull
    public static VersionedOS fromUserAgent(@Nonnull UserAgent agent) {
        OperatingSystem os = agent.getOperatingSystem();
        Version version = VersionedOS.getVersion((UserAgent)agent);
        int majorVersion = VersionedOS.parseVersionNumberFrom((String)version.getMajorVersion());
        int minorVersion = VersionedOS.parseVersionNumberFrom((String)version.getMinorVersion());
        String fullVersion = Strings.nullToEmpty((String)version.getVersion());
        return new VersionedOS(os, fullVersion, majorVersion, minorVersion);
    }

    private static int parseVersionNumberFrom(String versionNumber) {
        if (Strings.isNullOrEmpty((String)versionNumber)) {
            return -1;
        }
        try {
            return Integer.parseInt(versionNumber);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Nonnull
    private static Version getVersion(@Nonnull UserAgent userAgent) {
        String userAgentString = userAgent.getUserAgentString();
        if (userAgent.isIOS()) {
            return VersionedOS.parseOsVersion((String)VersionedOS.getIOSVersion((String)userAgentString));
        }
        if (userAgent.isAndroid()) {
            return VersionedOS.parseOsVersion((String)VersionedOS.getAndroidVersion((String)userAgentString));
        }
        if (userAgent.isWindowsPhone()) {
            return VersionedOS.parseOsVersion((String)VersionedOS.getWindowsPhoneVersion((String)userAgentString));
        }
        return UNKNOWN_VERSION;
    }

    @Nonnull
    private static Version parseOsVersion(@Nullable String osVersionString) {
        if (Strings.isNullOrEmpty((String)osVersionString)) {
            return UNKNOWN_VERSION;
        }
        Iterator it = Splitter.on((char)'.').split((CharSequence)osVersionString).iterator();
        String majorVersion = (String)it.next();
        String minorVersion = it.hasNext() ? (String)it.next() : "";
        return new Version(osVersionString, majorVersion, minorVersion);
    }

    public static String getAndroidVersion(String ua) {
        Matcher m = ANDROID_PATTERN.matcher(ua);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    @Nullable
    public static String getIOSVersion(@Nullable String ua) {
        if (ua == null) {
            return null;
        }
        StringBuilder versionBuilder = new StringBuilder(6);
        int index = ua.indexOf("OS ");
        if (index == -1) {
            return null;
        }
        if (!Character.isDigit(ua.charAt(index += 3))) {
            return null;
        }
        while (index < ua.length() && ua.charAt(index) != ' ') {
            versionBuilder.append(ua.charAt(index));
            ++index;
        }
        return versionBuilder.toString().replace('_', '.');
    }

    public static String getWindowsPhoneVersion(String ua) {
        if (ua == null) {
            return null;
        }
        StringBuilder versionBuilder = new StringBuilder(6);
        int index = ua.indexOf("OS ");
        if (index == -1) {
            return null;
        }
        if (!Character.isDigit(ua.charAt(index += 3))) {
            return null;
        }
        while (index < ua.length() && ua.charAt(index) != ';') {
            versionBuilder.append(ua.charAt(index));
            ++index;
        }
        return versionBuilder.toString();
    }
}

