/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.pipet.deploy.useragent;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.indeed.proctor.pipet.deploy.useragent.UserAgentVersion;
import com.indeed.proctor.pipet.deploy.useragent.VersionedOS;
import eu.bitwalker.useragentutils.Browser;
import eu.bitwalker.useragentutils.DeviceType;
import eu.bitwalker.useragentutils.OperatingSystem;
import eu.bitwalker.useragentutils.Version;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;

public class UserAgent {
    @Nonnull
    private final eu.bitwalker.useragentutils.UserAgent userAgent;
    @Nonnull
    private final VersionedOS os;
    @Nonnull
    private final UserAgentVersion version;
    @Nonnull
    private final String userAgentString;
    private static final String NEXUS_7_SIGNATURE = "Nexus 7";
    private static final String KINDLE_FIRE_SIGNATURE = "Kindle Fire";
    private static final eu.bitwalker.useragentutils.UserAgent UNKNOWN_USER_AGENT = new eu.bitwalker.useragentutils.UserAgent(OperatingSystem.UNKNOWN, Browser.UNKNOWN);

    @Deprecated
    public UserAgent(@Nonnull String userAgentString) {
        this.userAgentString = userAgentString;
        this.userAgent = eu.bitwalker.useragentutils.UserAgent.parseUserAgentString((String)userAgentString);
        this.os = VersionedOS.fromUserAgent(this);
        this.version = UserAgentVersion.from(this.userAgent.getBrowserVersion());
    }

    private UserAgent(@Nullable String userAgentHeader, @Nonnull eu.bitwalker.useragentutils.UserAgent delegate, @Nonnull UserAgentVersion version) {
        this.userAgentString = Strings.nullToEmpty((String)userAgentHeader);
        this.userAgent = delegate;
        this.os = VersionedOS.fromUserAgent(this);
        this.version = version;
    }

    @Nonnull
    public Browser getBrowser() {
        return this.userAgent.getBrowser();
    }

    @Nonnull
    public static UserAgent extractUserAgent(@Nonnull HttpServletRequest request) {
        return UserAgent.newBuilder().setRequest(request).build();
    }

    @Nonnull
    public static UserAgent parseUserAgentString(@Nullable String userAgentString) {
        return UserAgent.newBuilder().setUserAgentString(userAgentString).build();
    }

    @Nonnull
    public static UserAgent extractUserAgentSafely(@Nonnull HttpServletRequest request) {
        return UserAgent.newBuilder().setRequest(request).buildSafely();
    }

    @Nonnull
    public static UserAgent parseUserAgentStringSafely(@Nullable String userAgentString) {
        return UserAgent.newBuilder().setUserAgentString(userAgentString).buildSafely();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAgent temp = (UserAgent)o;
        eu.bitwalker.useragentutils.UserAgent other = temp.userAgent;
        return this.userAgent.equals((Object)other);
    }

    public int hashCode() {
        return this.userAgent.hashCode();
    }

    @Nonnull
    public Version getBrowserVersion() {
        return (Version)Objects.firstNonNull((Object)this.userAgent.getBrowserVersion(), (Object)UserAgentVersion.UNKNOWN_VERSION);
    }

    @Nonnull
    public UserAgentVersion getVersion() {
        return this.version;
    }

    @Nonnull
    public OperatingSystem getOperatingSystem() {
        return (OperatingSystem)Objects.firstNonNull((Object)this.userAgent.getOperatingSystem(), (Object)OperatingSystem.UNKNOWN);
    }

    @Nonnull
    public VersionedOS getOS() {
        return this.os;
    }

    @Nonnull
    public DeviceType getDeviceType() {
        return (DeviceType)Objects.firstNonNull((Object)this.getOperatingSystem().getDeviceType(), (Object)DeviceType.UNKNOWN);
    }

    @Nonnull
    public String getUserAgentString() {
        return this.userAgentString;
    }

    public boolean isTablet() {
        return DeviceType.TABLET.equals((Object)this.getDeviceType()) || this.userAgentString.contains(NEXUS_7_SIGNATURE) || this.userAgentString.contains(KINDLE_FIRE_SIGNATURE);
    }

    public boolean isIOS() {
        OperatingSystem operatingSystemGroup = this.getOperatingSystem().getGroup();
        return this.isMobileDevice() && OperatingSystem.IOS.equals((Object)operatingSystemGroup);
    }

    public boolean isChromeForIOS() {
        return this.isIOS() && this.userAgentString.contains("CriOS");
    }

    public boolean isAndroid() {
        OperatingSystem operatingSystemGroup = this.getOperatingSystem().getGroup();
        return OperatingSystem.ANDROID.equals((Object)operatingSystemGroup);
    }

    public boolean isWindowsPhone() {
        return OperatingSystem.WINDOWS_MOBILE7.equals((Object)this.getOperatingSystem());
    }

    public boolean isMobileDevice() {
        return this.getOperatingSystem().isMobileDevice() || this.isTablet();
    }

    public boolean isSmartPhone() {
        OperatingSystem operatingSystemGroup = this.getOperatingSystem().getGroup();
        return this.isMobileDevice() && (OperatingSystem.IOS.equals((Object)operatingSystemGroup) || OperatingSystem.ANDROID.equals((Object)operatingSystemGroup) || OperatingSystem.WINDOWS_MOBILE7.equals((Object)this.getOperatingSystem()));
    }

    public boolean isPhone() {
        return this.getOperatingSystem().isMobileDevice() && !this.isTablet();
    }

    public boolean isDumbPhone() {
        return this.isPhone() && !this.isSmartPhone();
    }

    private boolean meetsMinimumVersion(int minMajorVersion, int minMinorVersion, int majorVersion, int minorVersion) {
        return majorVersion > minMajorVersion || majorVersion == minMajorVersion && minorVersion >= minMinorVersion;
    }

    public String toString() {
        return this.userAgent.toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    protected static int getIntegerParameter(String argument, int defaultValue) {
        try {
            return argument != null ? Integer.parseInt(argument) : defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static class Builder {
        private HttpServletRequest request;
        private String userAgentString;

        private Builder() {
        }

        public Builder setRequest(@Nonnull HttpServletRequest request) {
            this.request = request;
            this.userAgentString = request.getHeader("User-Agent");
            return this;
        }

        public Builder setUserAgentString(@Nullable String userAgentString) {
            this.userAgentString = userAgentString;
            return this;
        }

        @Nullable
        private static UserAgentVersion parseVersion(@Nullable String versionString) {
            if (null == versionString) {
                return null;
            }
            Iterator splits = Splitter.on((char)'.').split((CharSequence)versionString).iterator();
            int majorVersion = splits.hasNext() ? UserAgent.getIntegerParameter((String)splits.next(), -1) : -1;
            int minorVersion = splits.hasNext() ? UserAgent.getIntegerParameter((String)splits.next(), -1) : -1;
            return new UserAgentVersion(versionString, majorVersion, minorVersion);
        }

        @Nonnull
        public UserAgent build() {
            if (null == this.userAgentString) {
                return new UserAgent(null, UNKNOWN_USER_AGENT, UserAgentVersion.UNKNOWN);
            }
            eu.bitwalker.useragentutils.UserAgent userAgent = eu.bitwalker.useragentutils.UserAgent.parseUserAgentString((String)this.userAgentString);
            eu.bitwalker.useragentutils.UserAgent userAgentToUse = (eu.bitwalker.useragentutils.UserAgent)Objects.firstNonNull((Object)userAgent, (Object)UNKNOWN_USER_AGENT);
            UserAgentVersion version = UserAgentVersion.from(userAgent.getBrowserVersion());
            return new UserAgent(this.userAgentString, userAgentToUse, version);
        }

        public UserAgent buildSafely() {
            try {
                return this.build();
            }
            catch (RuntimeException e) {
                return new UserAgent(this.userAgentString, UNKNOWN_USER_AGENT, UserAgentVersion.UNKNOWN);
            }
        }
    }
}

