/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.pipet.deploy;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.indeed.proctor.common.AbstractProctorLoader;
import com.indeed.proctor.pipet.core.config.CoreConfig;
import com.indeed.proctor.pipet.core.config.JsonPipetConfig;
import com.indeed.proctor.pipet.core.config.VariableConfigurationJsonParser;
import com.indeed.proctor.pipet.core.var.ValueConverter;
import com.indeed.proctor.pipet.core.var.VariableConfiguration;
import com.indeed.proctor.pipet.deploy.useragent.UserAgentValueConverter;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableWebMvc
@EnableScheduling
@Import(value={CoreConfig.class})
@ComponentScan(value={"com.indeed.proctor.pipet.core"})
public class AppConfig
extends WebMvcConfigurerAdapter {
    @Bean
    public JsonPipetConfig jsonPipetConfig(@Value(value="${proctor.pipet.config.path}") String pipetConfigPath) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (JsonPipetConfig)mapper.readValue(new File(pipetConfigPath), JsonPipetConfig.class);
    }

    @Bean
    public PropertySourcesPlaceholderConfigurer placeholderConfigurer() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    @Bean
    @Autowired
    public VariableConfiguration variableConfiguration(JsonPipetConfig jsonPipetConfig) {
        return VariableConfigurationJsonParser.newParser().registerStandardConverters().registerValueConverterByCanonicalName((ValueConverter)UserAgentValueConverter.userAgentValueConverter()).registerValueConverterBySimpleName((ValueConverter)UserAgentValueConverter.userAgentValueConverter()).buildFrom(jsonPipetConfig);
    }

    @Bean(destroyMethod="shutdownNow")
    @Autowired
    public ScheduledExecutorService scheduledExecutorService(AbstractProctorLoader loader, @Value(value="${proctor.pipet.reload.seconds}") int proctorReloadSeconds) {
        ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder();
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(4, threadFactoryBuilder.build());
        executorService.scheduleWithFixedDelay((Runnable)loader, 0L, proctorReloadSeconds, TimeUnit.SECONDS);
        return executorService;
    }
}

