/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.indeed.proctor.common.ProctorUtils;
import com.indeed.proctor.common.Serializers;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import com.indeed.proctor.common.model.TestDefinition;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class TestDefinitionValidator {
    private static final ObjectMapper OBJECT_MAPPER = Serializers.lenient();

    private TestDefinitionValidator() {
    }

    private static boolean isValidTestDefinition(InputStream stream, String testName, String matrixSource) {
        try {
            TestDefinition testDefinition = (TestDefinition)OBJECT_MAPPER.readValue(stream, TestDefinition.class);
            ConsumableTestDefinition consumableTestDefinition = ConsumableTestDefinition.fromTestDefinition(testDefinition);
            ProctorUtils.verifyInternallyConsistentDefinition(testName, matrixSource, consumableTestDefinition);
            return true;
        }
        catch (Throwable e) {
            System.err.println("Error: " + e.getMessage());
            return false;
        }
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.err.println("Usage: java " + TestDefinitionValidator.class.getCanonicalName() + " <test_name> <matrix_source> <test_path>");
            System.exit(0);
        }
        String testName = args[0];
        String matrixSource = args[1];
        InputStream stream = null;
        try {
            stream = "-".equals(args[2]) ? System.in : new FileInputStream(args[2]);
        }
        catch (FileNotFoundException e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }
        boolean result = TestDefinitionValidator.isValidTestDefinition(stream, testName, matrixSource);
        System.exit(result ? 0 : 1);
    }
}

