/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.indeed.proctor.common.AbstractJsonProctorLoader;
import com.indeed.proctor.common.ProctorSpecification;
import com.indeed.proctor.common.RuleEvaluator;
import com.indeed.proctor.common.model.TestMatrixArtifact;
import com.indeed.shaded.javax.el7.FunctionMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class UrlProctorLoader
extends AbstractJsonProctorLoader {
    @Nonnull
    private final URL inputURL;

    public UrlProctorLoader(@Nonnull ProctorSpecification specification, @Nonnull String inputUrl) throws MalformedURLException {
        this(specification, new URL(inputUrl));
    }

    public UrlProctorLoader(@Nonnull ProctorSpecification specification, @Nonnull String inputUrl, FunctionMapper functionMapper) throws MalformedURLException {
        this(specification, new URL(inputUrl), functionMapper);
    }

    public UrlProctorLoader(@Nonnull ProctorSpecification specification, @Nonnull URL inputUrl) {
        this(specification, inputUrl, RuleEvaluator.FUNCTION_MAPPER);
    }

    public UrlProctorLoader(@Nonnull ProctorSpecification specification, @Nonnull URL inputUrl, FunctionMapper functionMapper) {
        super(UrlProctorLoader.class, specification, functionMapper);
        this.inputURL = inputUrl;
    }

    @Override
    @Nonnull
    protected String getSource() {
        return this.inputURL.toString();
    }

    @Override
    @CheckForNull
    protected TestMatrixArtifact loadTestMatrix() throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputURL.openStream()));){
            TestMatrixArtifact testMatrixArtifact = this.loadJsonTestMatrix(reader);
            return testMatrixArtifact;
        }
    }
}

