/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.indeed.proctor.common.dynamic.DynamicFilters;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.annotation.Nonnull;

public class Serializers {
    private Serializers() {
    }

    @Nonnull
    public static ObjectMapper getObjectMapper() {
        return Serializers.lenient();
    }

    public static ObjectMapper lenient() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleModule module = new SimpleModule();
        PlainNumericSerializer plainNumericSerializer = new PlainNumericSerializer();
        module.addSerializer(Double.TYPE, (JsonSerializer)plainNumericSerializer);
        module.addSerializer(Double.class, (JsonSerializer)plainNumericSerializer);
        module.registerSubtypes((Class[])DynamicFilters.getFilterTypes());
        mapper.registerModule((Module)module);
        return mapper;
    }

    @Nonnull
    public static ObjectMapper strict() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        SimpleModule module = new SimpleModule();
        PlainNumericSerializer plainNumericSerializer = new PlainNumericSerializer();
        module.addSerializer(Double.TYPE, (JsonSerializer)plainNumericSerializer);
        module.addSerializer(Double.class, (JsonSerializer)plainNumericSerializer);
        module.registerSubtypes((Class[])DynamicFilters.getFilterTypes());
        mapper.registerModule((Module)module);
        return mapper;
    }

    private static class PlainNumericSerializer
    extends JsonSerializer<Double> {
        private final DecimalFormat decimalFormat = new DecimalFormat("0.0");

        private PlainNumericSerializer() {
            this.decimalFormat.setMaximumFractionDigits(10);
        }

        public void serialize(Double aDouble, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            jsonGenerator.writeNumber(this.decimalFormat.format(aDouble));
        }
    }
}

