/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.google.common.collect.Maps;
import com.indeed.proctor.common.model.ConsumableTestDefinition;
import com.indeed.proctor.common.model.TestBucket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class ProctorResult {
    public static final ProctorResult EMPTY = new ProctorResult("", Collections.<String, TestBucket>emptyMap(), Collections.<String, ConsumableTestDefinition>emptyMap());
    private final String matrixVersion;
    @Nonnull
    private final Map<String, TestBucket> buckets;
    @Nonnull
    private final Map<String, ConsumableTestDefinition> testDefinitions;

    @Deprecated
    public ProctorResult(int matrixVersion, @Nonnull Map<String, TestBucket> buckets, @Nonnull Map<String, ConsumableTestDefinition> testDefinitions) {
        this(new Integer(matrixVersion).toString(), buckets, testDefinitions);
    }

    public ProctorResult(String matrixVersion, @Nonnull Map<String, TestBucket> buckets, @Nonnull Map<String, ConsumableTestDefinition> testDefinitions) {
        this.matrixVersion = matrixVersion;
        this.buckets = Maps.newTreeMap();
        this.buckets.putAll(buckets);
        this.testDefinitions = testDefinitions;
    }

    public String getMatrixVersion() {
        return this.matrixVersion;
    }

    @Nonnull
    public Map<String, TestBucket> getBuckets() {
        return this.buckets;
    }

    @Nonnull
    public Map<String, ConsumableTestDefinition> getTestDefinitions() {
        return this.testDefinitions;
    }

    @Nonnull
    public Map<String, String> getTestVersions() {
        HashMap testVersions = Maps.newHashMap();
        for (Map.Entry<String, ConsumableTestDefinition> entry : this.testDefinitions.entrySet()) {
            testVersions.put(entry.getKey(), entry.getValue().getVersion());
        }
        return testVersions;
    }
}

